/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.jdbc.EmbeddedXADataSource;

class XADatabase
extends Database {
    private EmbeddedXADataSource xaDataSource;
    private XAResource xaResource;
    private XAConnection xaConnection;

    XADatabase(String string) {
        super(string);
        this.forXA = true;
    }

    synchronized void makeConnection(Properties properties) throws SQLException {
        EngineConnection engineConnection;
        if (this.xaDataSource == null) {
            this.xaDataSource = new EmbeddedXADataSource();
        }
        this.xaDataSource.setDatabaseName(this.shortDbName);
        this.appendAttrString(properties);
        if (this.attrString != null) {
            this.xaDataSource.setConnectionAttributes(this.attrString);
        }
        if ((engineConnection = this.getConnection()) == null) {
            this.xaConnection = this.xaDataSource.getXAConnection(this.userId, this.password);
            this.setXAResource(this.xaConnection.getXAResource());
        } else {
            engineConnection.close();
        }
        engineConnection = (EngineConnection)this.xaConnection.getConnection();
        engineConnection.setAutoCommit(false);
        this.setConnection(engineConnection);
    }

    protected void setXAResource(XAResource xAResource) {
        this.xaResource = xAResource;
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }
}

