/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;

public final class PEDomainXmlTokens {
    public static final String CONFIG_MODEL_NAME_TOKEN_NAME = "CONFIG_MODEL_NAME";
    public static final String CONFIG_MODEL_NAME_TOKEN_VALUE = "server-config";
    public static final String HOST_NAME_TOKEN_NAME = "HOST_NAME";
    public static final String DOMAIN_NAME_TOKEN_NAME = "DOMAIN_NAME";
    public static final String HTTP_PORT_TOKEN_NAME = "HTTP_PORT";
    public static final String ORB_LISTENER_PORT_TOKEN_NAME = "ORB_LISTENER_PORT";
    public static final String JMS_PROVIDER_PASSWORD_TOKEN_NAME = "JMS_PROVIDER_PASSWORD";
    public static final String JMS_PROVIDER_PORT_TOKEN_NAME = "JMS_PROVIDER_PORT";
    public static final String JMS_PROVIDER_USERID_TOKEN_NAME = "JMS_PROVIDER_USERID";
    public static final String SERVER_ID_TOKEN_NAME = "SERVER_ID";
    public static final String ADMIN_PORT_TOKEN_NAME = "ADMIN_PORT";
    public static final String HTTP_SSL_PORT_TOKEN_NAME = "HTTP_SSL_PORT";
    public static final String ORB_SSL_PORT_TOKEN_NAME = "ORB_SSL_PORT";
    public static final String ORB_MUTUALAUTH_PORT_TOKEN_NAME = "ORB_MUTUALAUTH_PORT";
    public static final String JMX_SYSTEM_CONNECTOR_PORT_TOKEN_NAME = "JMX_SYSTEM_CONNECTOR_PORT";

    public static TokenValueSet getTokenValueSet(DomainConfig domainConfig) {
        String installRoot = (String)domainConfig.get("install.root");
        String domainRoot = (String)domainConfig.get("domains.root");
        TokenValueSet tokens = new TokenValueSet();
        String instanceName = (String)domainConfig.get("server.id");
        if (instanceName == null || instanceName.equals("")) {
            instanceName = "server";
        }
        TokenValue tv = new TokenValue(CONFIG_MODEL_NAME_TOKEN_NAME, CONFIG_MODEL_NAME_TOKEN_VALUE);
        tokens.add(tv);
        tv = new TokenValue(HOST_NAME_TOKEN_NAME, (String)domainConfig.get("domain.hostName"));
        tokens.add(tv);
        Integer adminPort = (Integer)domainConfig.get("domain.adminPort");
        tv = new TokenValue(ADMIN_PORT_TOKEN_NAME, adminPort.toString());
        tokens.add(tv);
        Integer httpPort = (Integer)domainConfig.get("domain.instancePort");
        tv = new TokenValue(HTTP_PORT_TOKEN_NAME, httpPort.toString());
        tokens.add(tv);
        Integer orbPort = (Integer)domainConfig.get("orb.listener.port");
        tv = new TokenValue(ORB_LISTENER_PORT_TOKEN_NAME, orbPort.toString());
        tokens.add(tv);
        tv = new TokenValue(JMS_PROVIDER_PASSWORD_TOKEN_NAME, (String)domainConfig.get("jms.password"));
        tokens.add(tv);
        Integer jmsPort = (Integer)domainConfig.get("jms.port");
        tv = new TokenValue(JMS_PROVIDER_PORT_TOKEN_NAME, jmsPort.toString());
        tokens.add(tv);
        tv = new TokenValue(JMS_PROVIDER_USERID_TOKEN_NAME, (String)domainConfig.get("jms.user"));
        tokens.add(tv);
        tv = new TokenValue(SERVER_ID_TOKEN_NAME, instanceName);
        tokens.add(tv);
        Integer httpSslPort = (Integer)domainConfig.get("http.ssl.port");
        tv = new TokenValue(HTTP_SSL_PORT_TOKEN_NAME, httpSslPort.toString());
        tokens.add(tv);
        Integer orbSslPort = (Integer)domainConfig.get("orb.ssl.port");
        tv = new TokenValue(ORB_SSL_PORT_TOKEN_NAME, orbSslPort.toString());
        tokens.add(tv);
        Integer orbMutualAuthPort = (Integer)domainConfig.get("orb.mutualauth.port");
        tv = new TokenValue(ORB_MUTUALAUTH_PORT_TOKEN_NAME, orbMutualAuthPort.toString());
        tokens.add(tv);
        Integer jmxPort = (Integer)domainConfig.get("domain.jmxPort");
        tv = new TokenValue(JMX_SYSTEM_CONNECTOR_PORT_TOKEN_NAME, jmxPort.toString());
        tokens.add(tv);
        tv = new TokenValue(DOMAIN_NAME_TOKEN_NAME, domainConfig.getRepositoryName());
        tokens.add(tv);
        return tokens;
    }
}

