/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.concurrent.LinkedBlockingQueue;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXValidator;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public final class ComplianceMonitor
implements NotificationListener {
    private static ComplianceMonitor INSTANCE = null;
    private final DomainRoot mDomainRoot;
    private final MBeanServer mServer;
    private volatile boolean mStarted = false;
    private final ValidatorThread mValidatorThread;

    private ComplianceMonitor(DomainRoot domainRoot) {
        this.mDomainRoot = domainRoot;
        this.mServer = (MBeanServer)domainRoot.extra().mbeanServerConnection();
        this.mValidatorThread = new ValidatorThread(this.mServer);
    }

    private void listen() {
        try {
            JMXUtil.listenToMBeanServerDelegate((MBeanServerConnection)this.mServer, (NotificationListener)this, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void validate(ObjectName objectName) {
        this.mValidatorThread.add(objectName);
    }

    public static synchronized ComplianceMonitor getInstance(DomainRoot domainRoot) {
        if (INSTANCE == null) {
            INSTANCE = new ComplianceMonitor(domainRoot);
            INSTANCE.listen();
        }
        return INSTANCE;
    }

    public void start() {
        if (!this.mStarted) {
            this.mValidatorThread.start();
        }
    }

    public void handleNotification(Notification notifIn, Object handback) {
        MBeanServerNotification notif;
        ObjectName objectName;
        if (notifIn instanceof MBeanServerNotification && notifIn.getType().equals("JMX.mbean.registered") && (objectName = (notif = (MBeanServerNotification)notifIn).getMBeanName()).getDomain().equals(this.mDomainRoot.objectName().getDomain())) {
            this.mValidatorThread.add(objectName);
        }
    }

    private static final class ValidatorThread
    extends Thread {
        private final MBeanServer mServer;
        private final LinkedBlockingQueue<ObjectName> mMBeans = new LinkedBlockingQueue();

        ValidatorThread(MBeanServer server) {
            super("ComplianceMonitor.ValidatorThread");
            this.mServer = server;
        }

        void quit() {
            this.add(null);
        }

        public void add(ObjectName objectName) {
            this.mMBeans.add(objectName);
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        protected void doRun() throws Exception {
            ObjectName objectName;
            while ((objectName = this.mMBeans.take()) != null) {
                try {
                    AMXValidator validator = new AMXValidator((MBeanServerConnection)this.mServer);
                    AMXValidator.ValidationResult result = validator.validate(objectName);
                    if (result.numFailures() == 0) continue;
                    ImplUtil.getLogger().warning(result.toString());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

