/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Set;
import javax.context.Dependent;
import javax.event.Event;
import javax.event.Fires;
import javax.inject.AmbiguousDependencyException;
import javax.inject.DefinitionException;
import javax.inject.InconsistentSpecializationException;
import javax.inject.Instance;
import javax.inject.New;
import javax.inject.NullableDependencyException;
import javax.inject.Obtains;
import javax.inject.UnproxyableDependencyException;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.UnserializableDependencyException;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.NewSimpleBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.injection.resolution.ResolvableAnnotatedClass;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.ListComparator;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidator {
    private final ManagerImpl manager;

    public BeanValidator(ManagerImpl manager) {
        this.manager = manager;
    }

    public void validate() {
        ArrayList specializedBeans = new ArrayList();
        for (Bean<?> bean : this.manager.getBeans()) {
            boolean normalScoped;
            RIBean abstractBean;
            for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
                if (injectionPoint.getAnnotation(New.class) != null && injectionPoint.getBindings().size() > 1) {
                    throw new DefinitionException("The injection point " + injectionPoint + " is annotated with @New which cannot be combined with other binding types");
                }
                if (injectionPoint.getType() instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
                    for (Type type : parameterizedType.getActualTypeArguments()) {
                        if (type instanceof TypeVariable) {
                            throw new DefinitionException("Injection point cannot have a type variable type parameter " + injectionPoint);
                        }
                        if (!(type instanceof WildcardType)) continue;
                        throw new DefinitionException("Injection point cannot have a wildcard type parameter " + injectionPoint);
                    }
                }
                this.checkFacadeInjectionPoint(injectionPoint, Obtains.class, Instance.class);
                this.checkFacadeInjectionPoint(injectionPoint, Fires.class, Event.class);
                Annotation[] bindings = injectionPoint.getBindings().toArray(new Annotation[0]);
                ResolvableAnnotatedClass annotatedItem = ResolvableAnnotatedClass.of(injectionPoint.getType(), bindings);
                Set resolvedBeans = this.manager.resolveByType(annotatedItem, injectionPoint, bindings);
                if (resolvedBeans.isEmpty()) {
                    throw new UnsatisfiedDependencyException("The injection point " + injectionPoint + " with binding types " + Names.annotationsToString(injectionPoint.getBindings()) + " in " + bean + " has unsatisfied dependencies with binding types ");
                }
                if (resolvedBeans.size() > 1) {
                    throw new AmbiguousDependencyException("The injection point " + injectionPoint + " with binding types " + Names.annotationsToString(injectionPoint.getBindings()) + " in " + bean + " has ambiguous dependencies");
                }
                Bean resolvedBean = resolvedBeans.iterator().next();
                if (this.manager.getServices().get(MetaDataCache.class).getScopeModel(resolvedBean.getScopeType()).isNormal() && !Proxies.isTypeProxyable(injectionPoint.getType())) {
                    throw new UnproxyableDependencyException("The injection point " + injectionPoint + " has non-proxyable dependencies");
                }
                if (Reflections.isPrimitive(annotatedItem.getRawType()) && resolvedBean.isNullable()) {
                    throw new NullableDependencyException("The injection point " + injectionPoint + " has nullable dependencies");
                }
                if (!Beans.isPassivatingBean(bean, this.manager) || resolvedBean.isSerializable() || !resolvedBean.getScopeType().equals(Dependent.class)) continue;
                throw new UnserializableDependencyException("The bean " + bean + " declares a passivating scopes but has non-serializable dependency: " + resolvedBean);
            }
            if (bean instanceof RIBean && !(bean instanceof NewSimpleBean) && !(bean instanceof NewEnterpriseBean) && (abstractBean = (RIBean)bean).isSpecializing()) {
                if (!this.hasHigherPrecedence(bean.getDeploymentType(), abstractBean.getSpecializedBean().getDeploymentType())) {
                    throw new InconsistentSpecializationException("Specializing bean must have a higher precedence deployment type than the specialized bean: " + bean);
                }
                if (specializedBeans.contains(abstractBean.getSpecializedBean())) {
                    throw new InconsistentSpecializationException("Two beans cannot specialize the same bean: " + bean);
                }
                specializedBeans.add(abstractBean.getSpecializedBean());
            }
            if (!(normalScoped = this.manager.getServices().get(MetaDataCache.class).getScopeModel(bean.getScopeType()).isNormal()) || Beans.isBeanProxyable(bean)) continue;
            throw new UnproxyableDependencyException("Normal scoped bean " + bean + " is not proxyable");
        }
    }

    private boolean hasHigherPrecedence(Class<? extends Annotation> deploymentType, Class<? extends Annotation> otherDeploymentType) {
        ListComparator<Class<? extends Annotation>> comparator = new ListComparator<Class<? extends Annotation>>(this.manager.getEnabledDeploymentTypes());
        return comparator.compare(deploymentType, otherDeploymentType) > 0;
    }

    private void checkFacadeInjectionPoint(InjectionPoint injectionPoint, Class<? extends Annotation> annotationType, Class<?> type) {
        if (injectionPoint.isAnnotationPresent(annotationType)) {
            if (injectionPoint.getType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
                if (!type.isAssignableFrom((Class)parameterizedType.getRawType())) {
                    throw new DefinitionException("An injection point annotated " + annotationType + " must have type " + type + " " + injectionPoint);
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable) {
                    throw new DefinitionException("An injection point annotated " + annotationType + " cannot have a type variable type parameter " + injectionPoint);
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                    throw new DefinitionException("An injection point annotated " + annotationType + " cannot have a wildcard type parameter " + injectionPoint);
                }
            } else {
                throw new DefinitionException("An injection point annotated " + annotationType + " must have a type parameter " + injectionPoint);
            }
        }
    }
}

