/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import javax.context.Dependent;
import javax.event.Asynchronously;
import javax.event.IfExists;
import javax.event.Observer;
import javax.event.ObserverException;
import javax.event.Observes;
import javax.inject.DefinitionException;
import javax.inject.Disposes;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.DependentInstancesStore;
import org.jboss.webbeans.context.DependentStorageRequest;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverImpl<T>
implements Observer<T> {
    protected final Bean<?> observerBean;
    protected final MethodInjectionPoint<?> observerMethod;
    private final boolean conditional;
    private final boolean asynchronous;
    protected ManagerImpl manager;
    private final Type eventType;
    private final Annotation[] bindings;

    protected ObserverImpl(AnnotatedMethod<?> observer, Bean<?> observerBean, ManagerImpl manager) {
        this.manager = manager;
        this.observerBean = observerBean;
        this.observerMethod = MethodInjectionPoint.of(observerBean, observer);
        this.eventType = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getType();
        this.bindings = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getBindingsAsArray();
        this.conditional = !this.observerMethod.getAnnotatedParameters(IfExists.class).isEmpty();
        this.asynchronous = !this.observerMethod.getAnnotatedParameters(Asynchronously.class).isEmpty();
    }

    public void initialize() {
        this.checkObserverMethod();
    }

    private void checkObserverMethod() {
        List<AnnotatedParameter<?>> disposeParams;
        AnnotatedParameter<?> eventParam;
        List<AnnotatedParameter<?>> eventObjects = this.observerMethod.getAnnotatedParameters(Observes.class);
        if (eventObjects.size() > 1) {
            throw new DefinitionException(this + " is invalid because it contains more than event parameter annotated @Observes");
        }
        if (eventObjects.size() > 0 && (eventParam = eventObjects.iterator().next()).isParameterizedType()) {
            for (Type type : eventParam.getActualTypeArguments()) {
                if (type instanceof TypeVariable) {
                    throw new DefinitionException("Cannot use a type variable " + type + " in an parameterized type " + this.toString());
                }
                if (!(type instanceof WildcardType)) continue;
                throw new DefinitionException("Cannot use a wildcard variable " + type + " in an parameterized type " + this.toString());
            }
        }
        if ((disposeParams = this.observerMethod.getAnnotatedParameters(Disposes.class)).size() > 0) {
            throw new DefinitionException(this + " cannot have any parameters annotated with @Disposes");
        }
        if (this.observerMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Produces");
        }
        if (this.observerMethod.isAnnotationPresent(Initializer.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Initializer");
        }
        if (this.asynchronous && this.conditional) {
            throw new DefinitionException(this + " cannot be annotated with both @Asynchronously and @IfExists");
        }
    }

    @Override
    public void notify(T event) {
        if (this.asynchronous) {
            this.sendEventAsynchronously(event);
        } else {
            this.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(T event) {
        Object instance = null;
        DependentStorageRequest dependentStorageRequest = DependentStorageRequest.of(new DependentInstancesStore(), new Object());
        try {
            if (Dependent.class.equals(this.observerBean.getScopeType()) && this.observerBean instanceof RIBean) {
                DependentContext.instance().startCollectingDependents(dependentStorageRequest);
            }
            if ((instance = this.getInstance(this.observerBean)) == null) {
                return;
            }
            this.observerMethod.invokeOnInstanceWithSpecialValue(instance, Observes.class, event, this.manager, null, ObserverException.class);
        }
        finally {
            if (Dependent.class.equals(this.observerBean.getScopeType())) {
                DependentContext.instance().stopCollectingDependents(dependentStorageRequest);
                dependentStorageRequest.getDependentInstancesStore().destroyDependentInstances(dependentStorageRequest.getKey());
            }
        }
    }

    protected void sendEventAsynchronously(T event) {
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        this.manager.getTaskExecutor().execute(deferredEvent);
    }

    private <B> B getInstance(Bean<B> observerBean) {
        return this.manager.getInstance(observerBean, !this.isConditional());
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Observer Implementation: \n");
        builder.append("  Observer (Declaring) class: " + Names.typesToString(this.observerBean.getTypes()));
        builder.append("  Observer method: " + this.observerMethod);
        return builder.toString();
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Annotation[] getBindingsAsArray() {
        return this.bindings;
    }
}

