/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.reflect.Field;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedMember;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedFieldImpl<T>
extends AbstractAnnotatedMember<T, Field>
implements AnnotatedField<T> {
    private final Field field;
    private final AnnotatedType<?> declaringClass;
    private String toString;

    protected AnnotatedFieldImpl(Field field, AnnotatedType<?> declaringClass) {
        super(AnnotationStore.of(field), field, field.getType(), field.getGenericType());
        this.field = field;
        field.setAccessible(true);
        this.declaringClass = declaringClass;
    }

    @Override
    public Field getAnnotatedField() {
        return this.field;
    }

    @Override
    public Field getDelegate() {
        return this.field;
    }

    @Override
    public void set(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(instance, value);
    }

    public void setOnInstance(Object instance, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        instance.getClass().getField(this.getName()).set(instance, value);
    }

    @Override
    public T get(Object instance) {
        return (T)Reflections.getAndWrap(this.getDelegate(), instance);
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public AnnotatedType<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = Names.fieldToString(this.field) + " on " + this.getDeclaringClass();
        return this.toString;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AnnotatedField) {
            AnnotatedField that = (AnnotatedField)other;
            return this.getDeclaringClass().equals(that.getDeclaringClass()) && this.getName().equals(that.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

