/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.admin.config.PropertyBag;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.api.amx.AMXConfigInfo;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AMXConfigInfo(amxInterfaceName="com.sun.appserv.management.config.StandaloneServerConfig")
@Configured
public interface Server
extends ConfigBeanProxy,
Injectable,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer {
    @Attribute
    @NotNull
    public String getName();

    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    public String getConfigRef();

    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute
    public String getNodeAgentRef();

    public void setNodeAgentRef(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="100")
    @Min(value=1L)
    public String getLbWeight();

    public void setLbWeight(String var1) throws PropertyVetoException;

    @Element
    public List<ApplicationRef> getApplicationRef();

    @Element
    public List<ResourceRef> getResourceRef();

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system properties")
    @Element
    public List<SystemProperty> getSystemProperty();

    @DuckTyped
    public String getReference();

    @DuckTyped
    public ResourceRef getResourceRef(String var1);

    @DuckTyped
    public boolean isResourceRefExists(String var1);

    @DuckTyped
    public void deleteResourceRef(String var1) throws TransactionFailure;

    @DuckTyped
    public void createResourceRef(String var1, String var2) throws TransactionFailure;

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    public static class Duck {
        public static String getReference(Server server) {
            return server.getConfigRef();
        }

        public static ResourceRef getResourceRef(Server server, String refName) {
            for (ResourceRef ref : server.getResourceRef()) {
                if (!ref.getRef().equals(refName)) continue;
                return ref;
            }
            return null;
        }

        public static boolean isResourceRefExists(Server server, String refName) {
            return Duck.getResourceRef(server, refName) != null;
        }

        public static void deleteResourceRef(Server server, String refName) throws TransactionFailure {
            final ResourceRef ref = Duck.getResourceRef(server, refName);
            if (ref != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Server>(){

                    public Object run(Server param) {
                        return param.getResourceRef().remove(ref);
                    }
                }, (ConfigBeanProxy)server);
            }
        }

        public static void createResourceRef(Server server, final String enabled, final String refName) throws TransactionFailure {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Server>(){

                public Object run(Server param) throws PropertyVetoException, TransactionFailure {
                    ResourceRef newResourceRef = (ResourceRef)param.createChild(ResourceRef.class);
                    newResourceRef.setEnabled(enabled);
                    newResourceRef.setRef(refName);
                    param.getResourceRef().add(newResourceRef);
                    return newResourceRef;
                }
            }, (ConfigBeanProxy)server);
        }
    }
}

