/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.io;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartFile {
    private String path;
    private static final String SLASH = "/";

    public static File sanitize(File f) {
        SmartFile sf = new SmartFile(f);
        return new File(sf.path);
    }

    public static String sanitize(String filename) {
        SmartFile sf = new SmartFile(filename);
        return sf.path;
    }

    private SmartFile(File f) {
        if (f == null) {
            throw new NullPointerException();
        }
        this.convert(f.getAbsolutePath());
    }

    private SmartFile(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.convert(new File(s).getAbsolutePath());
    }

    private void convert(String oldPath) {
        if (GFLauncherUtils.isWindows()) {
            this.convertWindows(oldPath);
        } else {
            this.convertNix(oldPath);
        }
    }

    private void convertWindows(String oldPath) {
        try {
            this.path = new File(oldPath).getCanonicalPath();
            if (!this.path.startsWith("\\")) {
                this.path = this.path.replace('\\', '/');
            }
        }
        catch (IOException ex) {
            this.path = oldPath.replace('\\', '/');
        }
    }

    private void convertNix(String oldPath) {
        String[] elemsArray = oldPath.split(SLASH);
        ArrayList<String> elems = new ArrayList<String>();
        for (String s : elemsArray) {
            elems.add(s);
        }
        this.path = SLASH;
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            String elem = (String)it.next();
            if (elem.length() > 0) continue;
            it.remove();
        }
        block2: while (this.hasDots(elems)) {
            for (int i = 0; i < elems.size(); ++i) {
                String elem = (String)elems.get(i);
                if (elem.equals(".")) {
                    elems.remove(i);
                    continue block2;
                }
                if (!elem.equals("..")) continue;
                elems.remove(i);
                if (i <= 0) {
                    return;
                }
                elems.remove(i - 1);
                continue block2;
            }
        }
        for (String s : elems) {
            this.path = this.path + s + SLASH;
        }
        if (this.path.length() > 1) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    private boolean hasDots(List<String> elems) {
        return elems.contains(".") || elems.contains("..");
    }
}

