/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.moduleloader.IContent;

public class DirectoryContent
implements IContent {
    private static final int BUFSIZE = 4096;
    private static final transient String EMBEDDED_DIRECTORY = "-embedded";
    private static final transient String LIBRARY_DIRECTORY = "lib";
    private Logger m_logger;
    private final Object m_revisionLock;
    private File m_rootDir;
    private File m_dir;

    public DirectoryContent(Logger logger, Object revisionLock, File rootDir, File dir) {
        this.m_logger = logger;
        this.m_revisionLock = revisionLock;
        this.m_rootDir = rootDir;
        this.m_dir = dir;
    }

    public void close() {
    }

    public synchronized boolean hasEntry(String name) throws IllegalStateException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return new File(this.m_dir, name).exists();
    }

    public synchronized Enumeration getEntries() {
        EntriesEnumeration e = new EntriesEnumeration(this.m_dir);
        return e.hasMoreElements() ? e : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getEntryAsBytes(String name) throws IllegalStateException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            is = new BufferedInputStream(new FileInputStream(new File(this.m_dir, name)));
            baos = new ByteArrayOutputStream(4096);
            byte[] buf = new byte[4096];
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                baos.write(buf, 0, n);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public synchronized InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return new FileInputStream(new File(this.m_dir, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IContent getEntryAsContent(String entryName) {
        if (entryName.equals(".")) {
            return new DirectoryContent(this.m_logger, this.m_revisionLock, this.m_rootDir, this.m_dir);
        }
        entryName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        File embedDir = new File(this.m_rootDir, this.m_dir.getName() + EMBEDDED_DIRECTORY);
        File file = new File(this.m_dir, entryName);
        if (BundleCache.getSecureAction().isFileDirectory(file)) {
            return new DirectoryContent(this.m_logger, this.m_revisionLock, this.m_rootDir, file);
        }
        if (BundleCache.getSecureAction().fileExists(file) && entryName.endsWith(".jar")) {
            File extractedDir = new File(embedDir, entryName.lastIndexOf(47) >= 0 ? entryName.substring(0, entryName.lastIndexOf(47)) : entryName);
            Object object = this.m_revisionLock;
            synchronized (object) {
                if (!BundleCache.getSecureAction().fileExists(extractedDir) && !BundleCache.getSecureAction().mkdirs(extractedDir)) {
                    this.m_logger.log(1, "Unable to extract embedded directory.");
                }
            }
            return new JarContent(this.m_logger, this.m_revisionLock, extractedDir, file);
        }
        return null;
    }

    public synchronized String getEntryAsNativeLibrary(String name) {
        return BundleCache.getSecureAction().getAbsolutePath(new File(this.m_rootDir, name));
    }

    public String toString() {
        return "DIRECTORY " + this.m_dir;
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private File m_dir = null;
        private File[] m_children = null;
        private int m_counter = 0;

        public EntriesEnumeration(File dir) {
            this.m_dir = dir;
            this.m_children = this.listFilesRecursive(this.m_dir);
        }

        public boolean hasMoreElements() {
            return this.m_children != null && this.m_counter < this.m_children.length;
        }

        public Object nextElement() {
            if (this.m_children == null || this.m_counter >= this.m_children.length) {
                throw new NoSuchElementException("No more entry paths.");
            }
            String abs = this.m_children[this.m_counter].getAbsolutePath().replace(File.separatorChar, '/');
            StringBuffer sb = new StringBuffer(abs);
            sb.delete(0, this.m_dir.getAbsolutePath().length() + 1);
            if (this.m_children[this.m_counter].isDirectory()) {
                sb.append('/');
            }
            ++this.m_counter;
            return sb.toString();
        }

        public File[] listFilesRecursive(File dir) {
            File[] children;
            File[] combined = children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File[] grandchildren;
                if (!children[i].isDirectory() || (grandchildren = this.listFilesRecursive(children[i])).length <= 0) continue;
                File[] tmp = new File[combined.length + grandchildren.length];
                System.arraycopy(combined, 0, tmp, 0, combined.length);
                System.arraycopy(grandchildren, 0, tmp, combined.length, grandchildren.length);
                combined = tmp;
            }
            return combined;
        }
    }
}

