/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.config.GrizzlyUtils;
import com.sun.grizzly.config.HttpParserState;
import com.sun.grizzly.util.buf.Ascii;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.HexUtils;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public class HttpUtils {
    private static final int MAX_CONTEXT_ROOT_LENGTH = 2048;
    private static final String CSS = "H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}HR {color : #525D76;}";
    private static final int START_PARAM_IDX = 0;
    private static final int SEPARATOR_POS_PARAM_IDX = 2;
    private static final int C_PARAM_IDX = 3;
    private static final int PREV_PARAM_IDX = 4;

    public static byte[] readRequestLine(SelectionKey selectionKey, HttpParserState state, int timeout) throws IOException {
        int readBytes;
        ByteBuffer byteBuffer = state.getBuffer();
        do {
            byte[] contextRoot;
            if ((contextRoot = HttpUtils.findContextRoot(state)) == null) {
                if (byteBuffer.position() <= 2048 && (readBytes = GrizzlyUtils.readToWorkerThreadBuffers(selectionKey, timeout)) > 0) continue;
                return null;
            }
            return contextRoot;
        } while (readBytes > 0);
        return null;
    }

    public static byte[] readHost(SelectionKey selectionKey, HttpParserState state, int timeout) throws IOException {
        int readBytes;
        ByteBuffer byteBuffer = state.getBuffer();
        do {
            byte[] host = HttpUtils.findHost(state);
            if (!state.isCompleted() && host == null) {
                if (byteBuffer.position() <= 2048 && (readBytes = GrizzlyUtils.readToWorkerThreadBuffers(selectionKey, timeout)) > 0) continue;
                return null;
            }
            return host;
        } while (readBytes > 0);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] findContextRoot(HttpParserState lastState) {
        ByteBuffer byteBuffer = lastState.getBuffer();
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            return null;
        }
        byteBuffer.flip();
        byteBuffer.position(lastState.getPosition());
        try {
            byte c = (byte)lastState.getStateParameter(3, -1);
            byte prev = (byte)lastState.getStateParameter(4, -1);
            block9: while (byteBuffer.hasRemaining()) {
                byte prevPrev = prev;
                prev = c;
                c = byteBuffer.get();
                lastState.setPosition(byteBuffer.position());
                switch (lastState.getState()) {
                    case 0: {
                        if (c != 32) continue block9;
                        lastState.setState(1);
                        lastState.setStateParameter(0, byteBuffer.position());
                        continue block9;
                    }
                    case 1: {
                        if (prev == 32 && c == 32) {
                            lastState.setStateParameter(0, byteBuffer.position());
                            continue block9;
                        }
                        if (c == 47) {
                            if (prev == 47 && prevPrev == 58) {
                                lastState.setStateParameter(0, -1);
                                continue block9;
                            }
                            if (lastState.getStateParameter(0) == -1) {
                                lastState.setStateParameter(0, byteBuffer.position());
                                lastState.setStateParameter(2, -1);
                                continue block9;
                            }
                            if (lastState.getStateParameter(2) >= 0) continue block9;
                            if (byteBuffer.position() != lastState.getStateParameter(0) + 1) {
                                lastState.setStateParameter(2, byteBuffer.position() - 1);
                                continue block9;
                            }
                            lastState.setStateParameter(0, byteBuffer.position());
                            continue block9;
                        }
                        if (c != 32 && c != 59 && c != 63) continue block9;
                        int start = lastState.getStateParameter(0) - 1;
                        int end = byteBuffer.position() - 1;
                        byteBuffer.position(start);
                        byteBuffer.limit(end);
                        byte[] contextRoot = new byte[end - start];
                        byteBuffer.get(contextRoot);
                        byte[] byArray = contextRoot;
                        return byArray;
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] findHost(HttpParserState lastState) {
        ByteBuffer byteBuffer = lastState.getBuffer();
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == lastState.getPosition()) {
            return null;
        }
        byteBuffer.position(lastState.getPosition());
        byteBuffer.limit(curPosition);
        try {
            int rnCounter = 0;
            block14: while (byteBuffer.hasRemaining()) {
                byte c = (byte)Ascii.toLower((int)byteBuffer.get());
                if (c == 13 || c == 10) {
                    if (++rnCounter == 4) {
                        lastState.setCompleted(true);
                        byte[] byArray = null;
                        return byArray;
                    }
                } else {
                    rnCounter = 0;
                    lastState.setPosition(byteBuffer.position());
                }
                switch (lastState.getState()) {
                    case 0: {
                        if (c == 104) {
                            lastState.setState(1);
                            continue block14;
                        }
                        lastState.setState(0);
                        continue block14;
                    }
                    case 1: {
                        if (c == 111) {
                            lastState.setState(2);
                            continue block14;
                        }
                        lastState.setState(0);
                        continue block14;
                    }
                    case 2: {
                        if (c == 115) {
                            lastState.setState(3);
                            continue block14;
                        }
                        lastState.setState(0);
                        continue block14;
                    }
                    case 3: {
                        if (c == 116) {
                            lastState.setState(4);
                            continue block14;
                        }
                        lastState.setState(0);
                        continue block14;
                    }
                    case 4: {
                        if (c == 58) {
                            lastState.setState(5);
                            lastState.setStateParameter(0, byteBuffer.position() + 1);
                            continue block14;
                        }
                        lastState.setState(0);
                        continue block14;
                    }
                    case 5: {
                        while (c != 58 && c != 13 && c != 10) {
                            if (byteBuffer.hasRemaining()) {
                                c = byteBuffer.get();
                                lastState.setPosition(byteBuffer.position());
                                continue;
                            }
                            byte[] byArray = null;
                            return byArray;
                        }
                        int startPos = lastState.getStateParameter(0);
                        int endPos = byteBuffer.position() - 1;
                        byte[] host = new byte[endPos - startPos];
                        byteBuffer.position(startPos);
                        byteBuffer.limit(endPos);
                        byteBuffer.get(host);
                        lastState.setCompleted(true);
                        byte[] byArray = host;
                        return byArray;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findBytes(ByteBuffer byteBuffer, byte[] b) {
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            throw new IllegalStateException("Invalid state");
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        try {
            byte first = b[0];
            boolean start = false;
            int end = curPosition;
            int srcEnd = b.length;
            for (int i = 0; i <= end - srcEnd; ++i) {
                if (Ascii.toLower((int)byteBuffer.get(i)) != first) continue;
                int myPos = i + 1;
                int srcPos = 1;
                while (srcPos < srcEnd && Ascii.toLower((int)byteBuffer.get(myPos++)) == b[srcPos++]) {
                    if (srcPos != srcEnd) continue;
                    int n = i - 0;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
        }
    }

    public static void parseHost(MessageBytes hostMB, Socket socket) throws IOException {
        if (hostMB == null || hostMB.isNull()) {
            InetAddress localAddress = socket.getLocalAddress();
            byte[] host = localAddress.getHostName().getBytes();
            hostMB.setBytes(host, 0, host.length);
            return;
        }
        ByteChunk valueBC = hostMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        char[] hostNameC = new char[0];
        if (hostNameC.length < valueL) {
            hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            hostMB.setChars(hostNameC, 0, valueL);
        } else {
            hostMB.setChars(hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    throw new IOException("Invalid Host");
                }
                port += charValue * mult;
                mult *= 10;
            }
        }
    }

    public static byte[] getErrorPage(String serverName, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>");
        sb.append(serverName);
        sb.append("</title>");
        sb.append("<style><!--");
        sb.append(CSS);
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append("<h1>");
        sb.append(message);
        sb.append("</h1>");
        sb.append("</h3> type Status report<br>message<br>description Not Found</h3>");
        sb.append("<HR size=\"1\" noshade>");
        sb.append("<h3>").append(serverName).append("</h3>");
        sb.append("</body></html>");
        return sb.toString().getBytes();
    }
}

