/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class CMP3Policy
extends CMPPolicy {
    protected CMPPolicy.KeyElementAccessor[] keyClassFields;
    protected HashMap<DatabaseField, CMPPolicy.KeyElementAccessor> fieldToAccessorMap;
    protected String pkClassName;
    protected Class pkClass = null;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPKClassName() != null) {
            try {
                Class clazz = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getPKClassName(), true, classLoader));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), privilegedActionException.getException());
                    }
                } else {
                    clazz = PrivilegedAccessHelper.getClassForName((String)this.getPKClassName(), (boolean)true, (ClassLoader)classLoader);
                }
                this.setPKClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), classNotFoundException);
            }
        }
    }

    public boolean isCMP3Policy() {
        return true;
    }

    public void setPrimaryKeyClassName(String string) {
        this.pkClassName = string;
    }

    public Class getPKClass() {
        if (this.pkClass == null && this.getPKClassName() == null) {
            this.getKeyClassFields(null);
        }
        return this.pkClass;
    }

    public void setPKClass(Class clazz) {
        this.pkClass = clazz;
    }

    public String getPKClassName() {
        return this.pkClassName;
    }

    public Object getPKClassInstance() {
        try {
            return this.getPKClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Vector createPkVectorFromKey(Object object, AbstractSession abstractSession) {
        CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(object.getClass());
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector(keyElementAccessorArray.length);
        for (int i = 0; i < keyElementAccessorArray.length; ++i) {
            DatabaseMapping databaseMapping = keyElementAccessorArray[i].getMapping();
            Object object2 = null;
            if (databaseMapping.isDirectToFieldMapping()) {
                object2 = ((AbstractDirectMapping)databaseMapping).getFieldValue(keyElementAccessorArray[i].getValue(object, abstractSession), abstractSession);
            } else {
                object2 = keyElementAccessorArray[i].getValue(object, abstractSession);
                if (object2 != null && this.pkClass != null && databaseMapping.isOneToOneMapping()) {
                    OneToOneMapping oneToOneMapping = (OneToOneMapping)databaseMapping;
                    DatabaseField databaseField = (DatabaseField)oneToOneMapping.getSourceToTargetKeyFields().get(keyElementAccessorArray[i].getDatabaseField());
                    CMPPolicy cMPPolicy = oneToOneMapping.getReferenceDescriptor().getCMPPolicy();
                    if (cMPPolicy.isCMP3Policy()) {
                        Class clazz = cMPPolicy.getPKClass();
                        if (clazz != null && clazz != object2.getClass() && !clazz.isAssignableFrom(object2.getClass())) {
                            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_pk_class", (Object[])new Object[]{clazz, object2.getClass()}));
                        }
                        object2 = ((CMP3Policy)cMPPolicy).getPkValueFromKeyForField(object2, databaseField, abstractSession);
                    }
                }
            }
            nonSynchronizedVector.add(object2);
        }
        return nonSynchronizedVector;
    }

    public Object createBeanUsingKey(Object object, AbstractSession abstractSession) {
        try {
            Object object2 = this.getDescriptor().getInstantiationPolicy().buildNewInstance();
            CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(object.getClass());
            for (int i = 0; i < keyElementAccessorArray.length; ++i) {
                Object object3 = object2;
                Object object4 = keyElementAccessorArray[i].getValue(object, abstractSession);
                DatabaseField databaseField = keyElementAccessorArray[i].getDatabaseField();
                DatabaseMapping databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessorArray[i].getAttributeName());
                if (databaseMapping == null) {
                    databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(databaseField);
                }
                while (databaseMapping.isAggregateObjectMapping()) {
                    Object object5 = databaseMapping.getRealAttributeValueFromObject(object3, abstractSession);
                    if (object5 == null) {
                        object5 = databaseMapping.getReferenceDescriptor().getJavaClass().newInstance();
                        databaseMapping.setRealAttributeValueInObject(object3, object5);
                    }
                    if ((databaseMapping = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessorArray[i].getAttributeName())) == null) {
                        databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(databaseField);
                    }
                    object3 = object5;
                }
                databaseMapping.setRealAttributeValueInObject(object3, object4);
            }
            return object2;
        }
        catch (Exception exception) {
            throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.getDescriptor(), (Exception)exception);
        }
    }

    protected CMPPolicy.KeyElementAccessor[] initializePrimaryKeyFields(Class clazz, AbstractSession abstractSession) {
        CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = null;
        ClassDescriptor classDescriptor = this.getDescriptor();
        this.fieldToAccessorMap = new HashMap();
        int n = classDescriptor.getPrimaryKeyFields().size();
        keyElementAccessorArray = new CMPPolicy.KeyElementAccessor[n];
        Iterator iterator = classDescriptor.getPrimaryKeyFields().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            Vector<DatabaseMapping> vector = classDescriptor.getObjectBuilder().getReadOnlyMappingsForField(databaseField);
            if (vector == null) {
                vector = new Vector<DatabaseMapping>(1);
            }
            vector.add(classDescriptor.getObjectBuilder().getMappingForField(databaseField));
            DatabaseMapping databaseMapping = null;
            NoSuchMethodException noSuchMethodException = null;
            for (int i = vector.size() - 1; i >= 0; --i) {
                StringBuffer stringBuffer;
                Object object;
                String string;
                databaseMapping = (DatabaseMapping)vector.get(i);
                if (classDescriptor.isIDSpecified() && !databaseMapping.isIDMapping() || databaseMapping.isForeignReferenceMapping() && !databaseMapping.isOneToOneMapping()) continue;
                if (databaseMapping.isAggregateMapping()) {
                    string = databaseMapping.getReferenceDescriptor().getObjectBuilder();
                    object = string.getReadOnlyMappingsForField(databaseField);
                    if (object != null && !object.isEmpty()) {
                        vector.addAll((Collection<DatabaseMapping>)object);
                    }
                    if ((stringBuffer = string.getMappingForField(databaseField)) != null) {
                        vector.add((DatabaseMapping)stringBuffer);
                    }
                    vector.remove(databaseMapping);
                    i = vector.size();
                    continue;
                }
                string = databaseMapping.getAttributeName();
                if (clazz == null) {
                    keyElementAccessorArray[n2] = new CMPPolicy.KeyIsElementAccessor((CMPPolicy)this, string, databaseField, databaseMapping);
                    if (databaseMapping.isDirectToFieldMapping()) {
                        this.setPKClass(ConversionManager.getObjectClass((Class)databaseMapping.getAttributeClassification()));
                    } else if (databaseMapping.isOneToOneMapping()) {
                        object = databaseMapping.getReferenceDescriptor();
                        object.initialize(abstractSession);
                        stringBuffer = object.getCMPPolicy();
                        this.setPKClass(stringBuffer.getPKClass());
                    }
                    this.fieldToAccessorMap.put(databaseField, keyElementAccessorArray[n2]);
                    noSuchMethodException = null;
                } else {
                    try {
                        object = null;
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                object = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, string, true));
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                throw (NoSuchFieldException)privilegedActionException.getException();
                            }
                        } else {
                            object = PrivilegedAccessHelper.getField((Class)clazz, (String)string, (boolean)true);
                        }
                        keyElementAccessorArray[n2] = new FieldAccessor((Field)object, string, databaseField, databaseMapping);
                        this.fieldToAccessorMap.put(databaseField, keyElementAccessorArray[n2]);
                        noSuchMethodException = null;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("get");
                        stringBuffer.append(string.substring(0, 1).toUpperCase());
                        stringBuffer.append(string.substring(1));
                        try {
                            Method method = null;
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    method = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(clazz, stringBuffer.toString(), new Class[0], true));
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw (NoSuchMethodException)privilegedActionException.getException();
                                }
                            } else {
                                method = PrivilegedAccessHelper.getMethod((Class)clazz, (String)stringBuffer.toString(), (Class[])new Class[0], (boolean)true);
                            }
                            keyElementAccessorArray[n2] = new PropertyAccessor(method, string, databaseField, databaseMapping);
                            this.fieldToAccessorMap.put(databaseField, keyElementAccessorArray[n2]);
                            noSuchMethodException = null;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            noSuchMethodException = noSuchMethodException2;
                        }
                    }
                }
                if (databaseMapping.isIDMapping() || noSuchMethodException == null) break;
            }
            if (noSuchMethodException != null) {
                throw DescriptorException.errorUsingPrimaryKey((Object)clazz, (ClassDescriptor)this.getDescriptor(), noSuchMethodException);
            }
            ++n2;
        }
        return keyElementAccessorArray;
    }

    protected CMPPolicy.KeyElementAccessor[] getKeyClassFields(Class clazz) {
        return this.keyClassFields;
    }

    public Object getPkValueFromKeyForField(Object object, DatabaseField databaseField, AbstractSession abstractSession) {
        Object object2 = null;
        this.getKeyClassFields(object.getClass());
        CMPPolicy.KeyElementAccessor keyElementAccessor = this.fieldToAccessorMap.get(databaseField);
        DatabaseMapping databaseMapping = keyElementAccessor.getMapping();
        if (databaseMapping.isDirectToFieldMapping()) {
            object2 = ((AbstractDirectMapping)databaseMapping).getFieldValue(keyElementAccessor.getValue(object, abstractSession), abstractSession);
        } else {
            object2 = keyElementAccessor.getValue(object, abstractSession);
            if (databaseMapping.isOneToOneMapping()) {
                OneToOneMapping oneToOneMapping = (OneToOneMapping)databaseMapping;
                DatabaseField databaseField2 = (DatabaseField)oneToOneMapping.getSourceToTargetKeyFields().get(databaseField);
                CMPPolicy cMPPolicy = oneToOneMapping.getReferenceDescriptor().getCMPPolicy();
                if (cMPPolicy.isCMP3Policy()) {
                    Class clazz = cMPPolicy.getPKClass();
                    if (clazz != null && clazz != object2.getClass() && !clazz.isAssignableFrom(object2.getClass())) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_pk_class", (Object[])new Object[]{cMPPolicy.getPKClass(), object2.getClass()}));
                    }
                    object2 = ((CMP3Policy)cMPPolicy).getPkValueFromKeyForField(object2, databaseField2, abstractSession);
                }
            }
        }
        return object2;
    }

    public void initialize(ClassDescriptor classDescriptor, AbstractSession abstractSession) throws DescriptorException {
        super.initialize(classDescriptor, abstractSession);
        this.keyClassFields = this.initializePrimaryKeyFields(this.pkClass, abstractSession);
    }

    private class FieldAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Field field;
        protected String attributeName;
        protected DatabaseField databaseField;
        protected DatabaseMapping mapping;

        public FieldAccessor(Field field, String string, DatabaseField databaseField, DatabaseMapping databaseMapping) {
            this.field = field;
            this.attributeName = string;
            this.databaseField = databaseField;
            this.mapping = databaseMapping;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public Object getValue(Object object, AbstractSession abstractSession) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.field, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)privilegedActionException.getException());
                    }
                }
                return PrivilegedAccessHelper.getValueFromField((Field)this.field, (Object)object);
            }
            catch (Exception exception) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
            }
        }

        public void setValue(Object object, Object object2) {
            block5: {
                try {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetField(object.getClass(), this.field.getName(), true));
                            AccessController.doPrivileged(new PrivilegedSetValueInField(field, object, object2));
                            break block5;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)privilegedActionException.getException());
                        }
                    }
                    field = PrivilegedAccessHelper.getField(object.getClass(), (String)this.field.getName(), (boolean)true);
                    PrivilegedAccessHelper.setValueInField((Field)field, (Object)object, (Object)object2);
                }
                catch (Exception exception) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
                }
            }
        }
    }

    private class PropertyAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Method method;
        protected String attributeName;
        protected DatabaseField databaseField;
        protected DatabaseMapping mapping;

        public PropertyAccessor(Method method, String string, DatabaseField databaseField, DatabaseMapping databaseMapping) {
            this.method = method;
            this.attributeName = string;
            this.databaseField = databaseField;
            this.mapping = databaseMapping;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public Object getValue(Object object, AbstractSession abstractSession) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.method, object, new Object[0]));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw (IllegalAccessException)exception;
                        }
                        throw (InvocationTargetException)exception;
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)this.method, (Object)object, (Object[])new Object[0]);
            }
            catch (Exception exception) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
            }
        }

        public void setValue(Object object, Object object2) {
            block6: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(new MetadataMethod(this.method, object.getClass()).getSetMethod(), object, new Object[]{object2}));
                            break block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            if (exception instanceof IllegalAccessException) {
                                throw (IllegalAccessException)exception;
                            }
                            throw (InvocationTargetException)exception;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)new MetadataMethod(this.method, object.getClass()).getSetMethod(), (Object)object, (Object[])new Object[]{object2});
                }
                catch (Exception exception) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception);
                }
            }
        }
    }
}

