/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryInsideJarURLArchive
implements Archive {
    private JarFile jarFile;
    private URL rootURL;
    private String relativeRootPath;
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public DirectoryInsideJarURLArchive(URL uRL) throws IOException {
        this(uRL, Logger.global);
    }

    public DirectoryInsideJarURLArchive(URL uRL, Logger logger) throws IOException {
        logger.entering("DirectoryInsideJarURLArchive", "DirectoryInsideJarURLArchive", new Object[]{uRL});
        this.logger = logger;
        assert (uRL.getProtocol().equals("jar"));
        this.rootURL = uRL;
        JarURLConnection jarURLConnection = (JarURLConnection)JarURLConnection.class.cast(uRL.openConnection());
        this.jarFile = jarURLConnection.getJarFile();
        logger.logp(Level.FINER, "DirectoryInsideJarURLArchive", "DirectoryInsideJarURLArchive", "jarFile = {0}", this.jarFile);
        this.relativeRootPath = jarURLConnection.getEntryName();
        this.init();
    }

    private void init() {
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) continue;
            String string = jarEntry.getName();
            if (this.relativeRootPath == null) {
                this.entries.add(string);
                continue;
            }
            if (!string.startsWith(this.relativeRootPath)) continue;
            this.entries.add(string.substring(this.relativeRootPath.length()));
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String string) throws IOException {
        InputStream inputStream = this.entries.contains(string) ? this.jarFile.getInputStream(this.jarFile.getEntry(this.relativeRootPath + string)) : null;
        return inputStream;
    }

    @Override
    public URL getEntryAsURL(String string) throws IOException {
        URL uRL = this.entries.contains(string) ? new URL("jar:" + this.rootURL + "!/" + this.relativeRootPath + string) : null;
        return uRL;
    }

    @Override
    public URL getRootURL() {
        return this.rootURL;
    }
}

