/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.persistence.internal.jpa.transaction.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceImpl
implements DataSource {
    String dsName;
    String url;
    String userName;
    String password;
    TransactionManagerImpl tm;

    private void debug(String string) {
        System.out.println(string);
    }

    public DataSourceImpl(String string, String string2, String string3, String string4) {
        this.dsName = string;
        this.url = string2;
        this.userName = string3;
        this.password = string4;
    }

    public String getName() {
        return this.dsName;
    }

    public void setTransactionManager(TransactionManagerImpl transactionManagerImpl) {
        this.tm = transactionManagerImpl;
    }

    public Connection internalGetConnection(String string, String string2) throws SQLException {
        return DriverManager.getConnection(this.url, string, string2);
    }

    public Connection internalGetConnection() throws SQLException {
        return this.internalGetConnection(this.userName, this.password);
    }

    public boolean isTransactional() {
        return this.tm != null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.isTransactional() && this.tm.isTransactionActive()) {
            return this.tm.getConnection(this, string, string2);
        }
        this.debug("Ds - Allocating new non-tx connection");
        return this.internalGetConnection(string, string2);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        DriverManager.setLogWriter(printWriter);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

