/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataAnnotatedElement
extends MetadataAccessibleObject {
    public static final String JPA_PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";
    public static final String ECLIPSELINK_PERSISTENCE_PACKAGE_PREFIX = "org.eclipse.persistence.annotations";
    private String m_name;
    private Class m_rawClass;
    private Type m_relationType;
    private String m_attributeName;
    private AnnotatedElement m_annotatedElement;
    private HashMap<String, Annotation> m_annotations;

    protected MetadataAnnotatedElement(AnnotatedElement annotatedElement) {
        super(annotatedElement, null);
        this.setAnnotatedElement(annotatedElement);
    }

    public MetadataAnnotatedElement(AnnotatedElement annotatedElement, MetadataLogger metadataLogger) {
        super(annotatedElement, metadataLogger);
        this.setAnnotatedElement(annotatedElement);
    }

    public MetadataAnnotatedElement(AnnotatedElement annotatedElement, XMLEntityMappings xMLEntityMappings) {
        super(xMLEntityMappings.getMappingFile(), xMLEntityMappings);
        this.setAnnotatedElement(annotatedElement);
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    public <T extends Annotation> T getAnnotation(Class clazz) {
        return (T)this.m_annotations.get(clazz.getName());
    }

    public <T extends Annotation> T getAnnotation(String string, MetadataDescriptor metadataDescriptor) {
        Annotation annotation = this.m_annotations.get(string);
        if (annotation != null && metadataDescriptor.ignoreAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_annotation", annotation, this.m_annotatedElement);
            return null;
        }
        return (T)annotation;
    }

    public Map<String, Annotation> getAnnotations() {
        return this.m_annotations;
    }

    @Override
    public String getAttributeName() {
        return this.m_attributeName;
    }

    protected int getDeclaredAnnotationsCount(MetadataDescriptor metadataDescriptor) {
        return metadataDescriptor.ignoreAnnotations() ? 0 : this.m_annotations.size();
    }

    @Override
    public Object getElement() {
        return this.getAnnotatedElement();
    }

    public Class getMapKeyClass(MetadataDescriptor metadataDescriptor) {
        if (this.isGenericCollectionType()) {
            Type type = ((ParameterizedType)this.m_relationType).getActualTypeArguments()[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            return (Class)metadataDescriptor.getGenericType(((TypeVariable)type).getName());
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public Class getRawClass(MetadataDescriptor metadataDescriptor) {
        if (this.m_rawClass == null) {
            if (this.isGenericCollectionType()) {
                return (Class)((ParameterizedType)this.m_relationType).getRawType();
            }
            if (this.m_relationType instanceof Class) {
                return (Class)this.m_relationType;
            }
            this.m_rawClass = (Class)metadataDescriptor.getGenericType(((TypeVariable)this.m_relationType).getName());
        }
        return this.m_rawClass;
    }

    public Class getReferenceClassFromGeneric(MetadataDescriptor metadataDescriptor) {
        if (this.isGenericCollectionType()) {
            ParameterizedType parameterizedType = (ParameterizedType)this.m_relationType;
            Type type = Map.class.isAssignableFrom((Class)parameterizedType.getRawType()) ? parameterizedType.getActualTypeArguments()[1] : parameterizedType.getActualTypeArguments()[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof TypeVariable) {
                Type type2 = metadataDescriptor.getGenericType(((TypeVariable)type).getName());
                if (type2 instanceof GenericArrayType) {
                    return Array.newInstance((Class)((GenericArrayType)type2).getGenericComponentType(), 0).getClass();
                }
                return (Class)type2;
            }
            if (type instanceof GenericArrayType) {
                return Array.newInstance((Class)((GenericArrayType)type).getGenericComponentType(), 0).getClass();
            }
            return null;
        }
        return null;
    }

    public Type getRelationType() {
        return this.m_relationType;
    }

    public boolean hasDeclaredAnnotations(MetadataDescriptor metadataDescriptor) {
        return this.getDeclaredAnnotationsCount(metadataDescriptor) > 0;
    }

    public boolean hasMoreThanOneDeclaredAnnotation(MetadataDescriptor metadataDescriptor) {
        return this.getDeclaredAnnotationsCount(metadataDescriptor) > 1;
    }

    public boolean isAnnotationNotPresent(Class clazz) {
        return !this.isAnnotationPresent(clazz);
    }

    public boolean isAnnotationPresent(Class clazz) {
        return this.getAnnotation(clazz) != null;
    }

    public boolean isAnnotationPresent(Class clazz, MetadataDescriptor metadataDescriptor) {
        Object t = this.getAnnotation(clazz);
        if (t != null && metadataDescriptor.ignoreAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_annotation", t, this.m_annotatedElement);
            return false;
        }
        return t != null;
    }

    public boolean isBasic(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(Basic.class, metadataDescriptor) || this.isAnnotationPresent(Lob.class, metadataDescriptor) || this.isAnnotationPresent(Temporal.class, metadataDescriptor) || this.isAnnotationPresent(Enumerated.class, metadataDescriptor);
    }

    public boolean isBasicCollection(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(BasicCollection.class, metadataDescriptor);
    }

    public boolean isBasicMap(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(BasicMap.class, metadataDescriptor);
    }

    public boolean isDerivedId(MetadataDescriptor metadataDescriptor) {
        return this.isId(metadataDescriptor) && (this.isOneToOne(metadataDescriptor) || this.isManyToOne(metadataDescriptor));
    }

    public boolean isElementCollection(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(ElementCollection.class, metadataDescriptor);
    }

    public boolean isEmbedded(MetadataDescriptor metadataDescriptor) {
        if (this.isAnnotationNotPresent(Embedded.class) && this.isAnnotationNotPresent(EmbeddedId.class)) {
            Class clazz = this.getRawClass(metadataDescriptor);
            MetadataClass metadataClass = new MetadataClass(clazz);
            return metadataClass.isAnnotationPresent(Embeddable.class) || metadataDescriptor.getProject().hasEmbeddable(clazz);
        }
        return this.isAnnotationPresent(Embedded.class, metadataDescriptor);
    }

    public boolean isEmbeddedId(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(EmbeddedId.class, metadataDescriptor);
    }

    public boolean isGenericCollectionType() {
        return this.m_relationType instanceof ParameterizedType;
    }

    public boolean isGenericType() {
        return this.m_relationType instanceof TypeVariable;
    }

    public boolean isId(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(Id.class, metadataDescriptor);
    }

    public boolean isManyToMany(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(ManyToMany.class, metadataDescriptor);
    }

    public boolean isManyToOne(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(ManyToOne.class, metadataDescriptor);
    }

    public boolean isOneToMany(MetadataDescriptor metadataDescriptor) {
        if (this.isAnnotationNotPresent(OneToMany.class) && !metadataDescriptor.ignoreDefaultMappings()) {
            if (this.isGenericCollectionType() && this.isSupportedToManyCollectionClass(metadataDescriptor) && metadataDescriptor.getProject().hasEntity(this.getReferenceClassFromGeneric(metadataDescriptor))) {
                this.getLogger().logConfigMessage("metadata_default_one_to_many_mapping", this.m_annotatedElement);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToMany.class, metadataDescriptor);
    }

    public boolean isOneToOne(MetadataDescriptor metadataDescriptor) {
        if (this.isAnnotationNotPresent(OneToOne.class) && !metadataDescriptor.ignoreDefaultMappings()) {
            if (metadataDescriptor.getProject().hasEntity(this.getRawClass(metadataDescriptor)) && !this.isEmbedded(metadataDescriptor)) {
                this.getLogger().logConfigMessage("metadata_default_one_to_one_mapping", this.m_annotatedElement);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToOne.class, metadataDescriptor);
    }

    public boolean isSupportedCollectionClass(MetadataDescriptor metadataDescriptor) {
        Class clazz = this.getRawClass(metadataDescriptor);
        return Collection.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz);
    }

    public boolean isSupportedMapClass(MetadataDescriptor metadataDescriptor) {
        return Map.class.isAssignableFrom(this.getRawClass(metadataDescriptor));
    }

    public boolean isSupportedToManyCollectionClass(MetadataDescriptor metadataDescriptor) {
        return this.isSupportedCollectionClass(metadataDescriptor) || this.isSupportedMapClass(metadataDescriptor);
    }

    public boolean isTransformation(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(ReadTransformer.class, metadataDescriptor) || this.isAnnotationPresent(WriteTransformers.class, metadataDescriptor) || this.isAnnotationPresent(WriteTransformer.class, metadataDescriptor);
    }

    protected boolean isValidPersistenceElement(boolean bl, String string, MetadataDescriptor metadataDescriptor) {
        if (bl) {
            Object t = this.getAnnotation("javax.persistence.Access", metadataDescriptor);
            if (t == null) {
                return false;
            }
            Enum enum_ = (Enum)MetadataHelper.invokeMethod("value", t);
            if (!enum_.name().equals(string)) {
                throw ValidationException.invalidExplicitAccessTypeSpecified((AnnotatedElement)this.getAnnotatedElement(), (Class)metadataDescriptor.getJavaClass(), (String)string);
            }
        }
        return true;
    }

    protected boolean isValidPersistenceElement(int n) {
        return !Modifier.isTransient(n) && !Modifier.isStatic(n) && !Modifier.isAbstract(n);
    }

    public boolean isVariableOneToOne(MetadataDescriptor metadataDescriptor) {
        if (this.isAnnotationNotPresent(VariableOneToOne.class) && !metadataDescriptor.ignoreDefaultMappings()) {
            if (this.getRawClass(metadataDescriptor).isInterface() && !Map.class.isAssignableFrom(this.getRawClass(metadataDescriptor)) && !Collection.class.isAssignableFrom(this.getRawClass(metadataDescriptor)) && !ValueHolderInterface.class.isAssignableFrom(this.getRawClass(metadataDescriptor))) {
                this.getLogger().logConfigMessage("metadata_default_variable_one_to_one_mapping", this.m_annotatedElement);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(VariableOneToOne.class, metadataDescriptor);
    }

    public boolean isVersion(MetadataDescriptor metadataDescriptor) {
        return this.isAnnotationPresent(Version.class, metadataDescriptor);
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.m_annotatedElement = annotatedElement;
        this.m_annotations = new HashMap();
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            String string = annotation.annotationType().getName();
            if (!string.startsWith(JPA_PERSISTENCE_PACKAGE_PREFIX) && !string.startsWith(ECLIPSELINK_PERSISTENCE_PACKAGE_PREFIX)) continue;
            String string2 = ((Object)annotation).toString().substring(1, ((Object)annotation).toString().indexOf("("));
            this.m_annotations.put(string2, annotation);
        }
    }

    protected void setAttributeName(String string) {
        this.m_attributeName = string;
    }

    protected void setName(String string) {
        this.m_name = string;
    }

    protected void setRelationType(Type type) {
        this.m_relationType = type;
    }
}

