/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

public class DiscriminatorClassMetadata
extends ORMetadata {
    private Class m_value;
    private String m_valueName;
    private String m_discriminator;

    public DiscriminatorClassMetadata() {
        super("<discriminator-class>");
    }

    public DiscriminatorClassMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.setDiscriminator((String)MetadataHelper.invokeMethod("discriminator", annotation));
        this.setValue((Class)MetadataHelper.invokeMethod("value", annotation));
    }

    public String getDiscriminator() {
        return this.m_discriminator;
    }

    public Class getValue() {
        return this.m_value;
    }

    public String getValueName() {
        return this.m_valueName;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_value = this.initXMLClassName(this.m_valueName);
    }

    public void process(VariableOneToOneMapping variableOneToOneMapping) {
        if (variableOneToOneMapping.getTypeIndicatorNameTranslation().containsValue(this.m_discriminator)) {
            throw ValidationException.multipleClassesForTheSameDiscriminator((String)this.m_discriminator, (String)variableOneToOneMapping.getAttributeName());
        }
        variableOneToOneMapping.addClassNameIndicator(this.m_value.getName(), (Object)this.m_discriminator);
    }

    public void setDiscriminator(String string) {
        this.m_discriminator = string;
    }

    public void setValue(Class clazz) {
        this.m_value = clazz;
    }

    public void setValueName(String string) {
        this.m_valueName = string;
    }
}

