/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFile;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsWriter;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEntityMappings
extends ORMetadata {
    private boolean m_isEclipseLinkORMFile = false;
    private ClassLoader m_loader;
    private List<EntityAccessor> m_entities;
    private List<ConverterMetadata> m_converters;
    private List<EmbeddableAccessor> m_embeddables;
    private List<MappedSuperclassAccessor> m_mappedSuperclasses;
    private List<NamedNativeQueryMetadata> m_namedNativeQueries;
    private List<NamedQueryMetadata> m_namedQueries;
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries;
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters;
    private List<SequenceGeneratorMetadata> m_sequenceGenerators;
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private List<StructConverterMetadata> m_structConverters;
    private List<TableGeneratorMetadata> m_tableGenerators;
    private List<TypeConverterMetadata> m_typeConverters;
    private MetadataFile m_file;
    private MetadataProject m_project;
    private String m_access;
    private String m_catalog;
    private String m_description;
    private String m_package;
    private String m_schema;
    private String m_version;
    private URL m_mappingFileURL;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;

    public XMLEntityMappings() {
        super("<entity-mappings>");
    }

    public String getAccess() {
        return this.m_access;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    protected Class getClassForName(String string, ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.unableToLoadClass((String)string, (Exception)privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName((String)string, (boolean)true, (ClassLoader)classLoader);
        }
        catch (Exception exception) {
            throw ValidationException.unableToLoadClass((String)string, (Exception)exception);
        }
    }

    public Class getClassForName(String string) {
        if (string == null || string.equals("")) {
            return Void.TYPE;
        }
        if (string.equalsIgnoreCase("Boolean")) {
            return Boolean.class;
        }
        if (string.equalsIgnoreCase("Byte")) {
            return Byte.class;
        }
        if (string.equalsIgnoreCase("Character")) {
            return Character.class;
        }
        if (string.equalsIgnoreCase("Double")) {
            return Double.class;
        }
        if (string.equalsIgnoreCase("Float")) {
            return Float.class;
        }
        if (string.equalsIgnoreCase("Integer")) {
            return Integer.class;
        }
        if (string.equalsIgnoreCase("Long")) {
            return Long.class;
        }
        if (string.equalsIgnoreCase("Number")) {
            return Number.class;
        }
        if (string.equalsIgnoreCase("Short")) {
            return Short.class;
        }
        if (string.equalsIgnoreCase("String")) {
            return String.class;
        }
        return this.getClassForName(this.getFullyQualifiedClassName(string), this.m_loader);
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public String getDescription() {
        return this.m_description;
    }

    protected String getDefaultCatalog() {
        if (this.m_catalog == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getCatalog();
        }
        return this.m_catalog;
    }

    protected String getDefaultSchema() {
        if (this.m_schema == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getSchema();
        }
        return this.m_schema;
    }

    public List<EmbeddableAccessor> getEmbeddables() {
        return this.m_embeddables;
    }

    public List<EntityAccessor> getEntities() {
        return this.m_entities;
    }

    public String getFullyQualifiedClassName(String string) {
        if (this.m_package == null || this.m_package.equals("")) {
            return string;
        }
        if (string.indexOf(".") > -1) {
            return string;
        }
        if (this.m_package.endsWith(".")) {
            return this.m_package + string;
        }
        return this.m_package + "." + string;
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public URL getMappingFile() {
        return this.m_mappingFileURL;
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public String getPackage() {
        return this.m_package;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public List<SequenceGeneratorMetadata> getSequenceGenerators() {
        return this.m_sequenceGenerators;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TableGeneratorMetadata> getTableGenerators() {
        return this.m_tableGenerators;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void initPersistenceUnitClasses(HashMap<String, EntityAccessor> hashMap, HashMap<String, EmbeddableAccessor> hashMap2) {
        Class clazz;
        for (EntityAccessor classAccessor : this.getEntities()) {
            clazz = this.getClassForName(classAccessor.getClassName());
            classAccessor.initXMLClassAccessor(new MetadataClass(clazz, this), new MetadataDescriptor(clazz, classAccessor), this.m_project);
            if (hashMap.containsKey(clazz.getName())) {
                hashMap.get(clazz.getName()).merge(classAccessor);
                continue;
            }
            hashMap.put(clazz.getName(), classAccessor);
        }
        for (EmbeddableAccessor embeddableAccessor : this.getEmbeddables()) {
            clazz = this.getClassForName(embeddableAccessor.getClassName());
            embeddableAccessor.initXMLClassAccessor(new MetadataClass(clazz, this), new MetadataDescriptor(clazz, embeddableAccessor), this.m_project);
            if (hashMap2.containsKey(clazz.getName())) {
                hashMap2.get(clazz.getName()).merge(embeddableAccessor);
                continue;
            }
            hashMap2.put(clazz.getName(), embeddableAccessor);
        }
        for (MappedSuperclassAccessor mappedSuperclassAccessor : this.getMappedSuperclasses()) {
            clazz = this.getClassForName(mappedSuperclassAccessor.getClassName());
            mappedSuperclassAccessor.setAccessibleObject(new MetadataClass(clazz, this));
            this.m_project.addMappedSuperclass(clazz.getName(), mappedSuperclassAccessor);
        }
    }

    public boolean isEclipseLinkORMFile() {
        return this.m_isEclipseLinkORMFile;
    }

    protected XMLEntityMappings newXMLEntityMappingsObject() {
        XMLEntityMappings xMLEntityMappings = new XMLEntityMappings();
        xMLEntityMappings.setVersion(this.getVersion());
        return xMLEntityMappings;
    }

    public void process() {
        for (ConverterMetadata oRMetadata : this.m_converters) {
            oRMetadata.initXMLObject(this.m_file);
            this.m_project.addConverter(oRMetadata);
        }
        for (TypeConverterMetadata typeConverterMetadata : this.m_typeConverters) {
            typeConverterMetadata.initXMLObject(this.m_file);
            this.m_project.addConverter(typeConverterMetadata);
        }
        for (ObjectTypeConverterMetadata objectTypeConverterMetadata : this.m_objectTypeConverters) {
            objectTypeConverterMetadata.initXMLObject(this.m_file);
            this.m_project.addConverter(objectTypeConverterMetadata);
        }
        for (StructConverterMetadata structConverterMetadata : this.m_structConverters) {
            structConverterMetadata.initXMLObject(this.m_file);
            this.m_project.addConverter(structConverterMetadata);
        }
        for (TableGeneratorMetadata tableGeneratorMetadata : this.m_tableGenerators) {
            tableGeneratorMetadata.initXMLObject(this.m_file);
            this.m_project.addTableGenerator(tableGeneratorMetadata, this.getDefaultCatalog(), this.getDefaultSchema());
        }
        for (SequenceGeneratorMetadata sequenceGeneratorMetadata : this.m_sequenceGenerators) {
            sequenceGeneratorMetadata.initXMLObject(this.m_file);
            this.m_project.addSequenceGenerator(sequenceGeneratorMetadata);
        }
        for (NamedQueryMetadata namedQueryMetadata : this.m_namedQueries) {
            namedQueryMetadata.initXMLObject(this.m_file);
            this.m_project.addQuery(namedQueryMetadata);
        }
        for (NamedNativeQueryMetadata namedNativeQueryMetadata : this.m_namedNativeQueries) {
            namedNativeQueryMetadata.initXMLObject(this.m_file);
            this.m_project.addQuery(namedNativeQueryMetadata);
        }
        for (NamedStoredProcedureQueryMetadata namedStoredProcedureQueryMetadata : this.m_namedStoredProcedureQueries) {
            namedStoredProcedureQueryMetadata.initXMLObject(this.m_file);
            this.m_project.addQuery(namedStoredProcedureQueryMetadata);
        }
        for (SQLResultSetMappingMetadata sQLResultSetMappingMetadata : this.m_sqlResultSetMappings) {
            sQLResultSetMappingMetadata.initXMLObject(this.m_file);
            this.m_project.addSQLResultSetMapping(sQLResultSetMappingMetadata);
        }
    }

    public void processEntityMappingsDefaults(ClassAccessor classAccessor) {
        MetadataDescriptor metadataDescriptor = classAccessor.getDescriptor();
        if (this.m_access != null) {
            metadataDescriptor.setDefaultAccess(this.m_access);
        }
        if (this.m_catalog != null) {
            metadataDescriptor.setDefaultCatalog(this.m_catalog);
        }
        if (this.m_schema != null) {
            metadataDescriptor.setDefaultSchema(this.m_schema);
        }
    }

    public void processPersistenceUnitMetadata() {
        this.m_file = new MetadataFile(this);
        if (this.m_persistenceUnitMetadata != null) {
            this.m_persistenceUnitMetadata.initXMLObject(this.m_file);
            this.m_project.setPersistenceUnitMetadata(this.m_persistenceUnitMetadata);
            for (EntityListenerMetadata entityListenerMetadata : this.m_persistenceUnitMetadata.getDefaultListeners()) {
                this.m_project.addDefaultListener(entityListenerMetadata);
            }
        }
    }

    @Override
    public EntityAccessor reloadEntity(EntityAccessor entityAccessor, MetadataDescriptor metadataDescriptor) {
        XMLEntityMappings xMLEntityMappings = this.newXMLEntityMappingsObject();
        ArrayList<EntityAccessor> arrayList = new ArrayList<EntityAccessor>();
        arrayList.add(entityAccessor);
        xMLEntityMappings.setEntities(arrayList);
        xMLEntityMappings = this.reloadXMLEntityMappingsObject(xMLEntityMappings);
        EntityAccessor entityAccessor2 = xMLEntityMappings.getEntities().get(0);
        Class clazz = this.getClassForName(entityAccessor2.getClassName());
        entityAccessor2.initXMLClassAccessor(new MetadataClass(clazz, this), metadataDescriptor, this.m_project);
        return entityAccessor2;
    }

    @Override
    public MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor mappedSuperclassAccessor, MetadataDescriptor metadataDescriptor) {
        XMLEntityMappings xMLEntityMappings = this.newXMLEntityMappingsObject();
        ArrayList<MappedSuperclassAccessor> arrayList = new ArrayList<MappedSuperclassAccessor>();
        arrayList.add(mappedSuperclassAccessor);
        xMLEntityMappings.setMappedSuperclasses(arrayList);
        xMLEntityMappings = this.reloadXMLEntityMappingsObject(xMLEntityMappings);
        MappedSuperclassAccessor mappedSuperclassAccessor2 = xMLEntityMappings.getMappedSuperclasses().get(0);
        Class clazz = this.getClassForName(mappedSuperclassAccessor2.getClassName());
        mappedSuperclassAccessor2.initXMLClassAccessor(new MetadataClass(clazz, this), metadataDescriptor, this.m_project);
        return mappedSuperclassAccessor2;
    }

    protected XMLEntityMappings reloadXMLEntityMappingsObject(XMLEntityMappings xMLEntityMappings) {
        try {
            File file = new File("tempToDelete.xml");
            XMLEntityMappingsWriter.write(xMLEntityMappings, file.toURI());
            XMLEntityMappings xMLEntityMappings2 = XMLEntityMappingsReader.read(file.toURL(), this.m_loader);
            file.delete();
            return xMLEntityMappings2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setAccess(String string) {
        this.m_access = string;
    }

    public void setCatalog(String string) {
        this.m_catalog = string;
    }

    public void setConverters(List<ConverterMetadata> list) {
        this.m_converters = list;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setEmbeddables(List<EmbeddableAccessor> list) {
        this.m_embeddables = list;
    }

    public void setEntities(List<EntityAccessor> list) {
        this.m_entities = list;
    }

    public void setIsEclipseLinkORMFile(boolean bl) {
        this.m_isEclipseLinkORMFile = bl;
    }

    public void setLoader(ClassLoader classLoader) {
        this.m_loader = classLoader;
    }

    public void setMappedSuperclasses(List<MappedSuperclassAccessor> list) {
        this.m_mappedSuperclasses = list;
    }

    public void setMappingFile(URL uRL) {
        this.m_mappingFileURL = uRL;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> list) {
        this.m_namedNativeQueries = list;
    }

    public void setNamedQueries(List<NamedQueryMetadata> list) {
        this.m_namedQueries = list;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> list) {
        this.m_namedStoredProcedureQueries = list;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> list) {
        this.m_objectTypeConverters = list;
    }

    public void setPackage(String string) {
        this.m_package = string;
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata xMLPersistenceUnitMetadata) {
        this.m_persistenceUnitMetadata = xMLPersistenceUnitMetadata;
    }

    public void setProject(MetadataProject metadataProject) {
        this.m_project = metadataProject;
    }

    public void setSchema(String string) {
        this.m_schema = string;
    }

    public void setSequenceGenerators(List<SequenceGeneratorMetadata> list) {
        this.m_sequenceGenerators = list;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> list) {
        this.m_sqlResultSetMappings = list;
    }

    public void setStructConverters(List<StructConverterMetadata> list) {
        this.m_structConverters = list;
    }

    public void setTableGenerators(List<TableGeneratorMetadata> list) {
        this.m_tableGenerators = list;
    }

    public void setTypeConverters(List<TypeConverterMetadata> list) {
        this.m_typeConverters = list;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }
}

