/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.jpa.ExceptionFactory;
import org.eclipse.persistence.internal.jpa.jdbc.ConnectionProxyHandler;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;

public class TransactionImpl
implements Transaction {
    boolean markedForRollback = false;
    int status = 0;
    Vector listeners = new Vector();
    Connection connection;
    static Class proxyClass = Proxy.getProxyClass(Connection.class.getClassLoader(), Connection.class);
    DataSourceImpl dataSource;
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_MARKED_ROLLBACK = 1;
    public static final int STATUS_PREPARED = 2;
    public static final int STATUS_COMMITTED = 3;
    public static final int STATUS_ROLLEDBACK = 4;
    public static final int STATUS_UNKNOWN = 5;
    public static final int STATUS_NO_TRANSACTION = 6;
    public static final int STATUS_PREPARING = 7;
    public static final int STATUS_COMMITTING = 8;
    public static final int STATUS_ROLLING_BACK = 9;
    public static boolean DUMP_AFTER_COMPLETION_ERRORS = true;

    private void debug(String string) {
        System.out.println(string);
    }

    public Connection getConnection(DataSourceImpl dataSourceImpl, String string, String string2) throws SQLException {
        if (this.connection == null) {
            this.debug("TxImpl - allocating new connection");
            this.dataSource = dataSourceImpl;
            this.connection = dataSourceImpl.internalGetConnection(string, string2);
            this.connection.setAutoCommit(false);
        } else if (dataSourceImpl.getName() != this.dataSource.getName()) {
            throw TransactionException.multipleResourceException();
        }
        this.debug("TxImpl - creating connection proxy");
        Connection connection = null;
        try {
            ConnectionProxyHandler connectionProxyHandler = new ConnectionProxyHandler(this.connection);
            connection = (Connection)proxyClass.getConstructor(InvocationHandler.class).newInstance(connectionProxyHandler);
        }
        catch (Exception exception) {
            throw TransactionException.internalProxyException((Exception)exception);
        }
        return connection;
    }

    public void invokeAfterCompletion() {
        this.debug("TxImpl - invoking afterCompletion");
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ((Synchronization)this.listeners.elementAt(i)).afterCompletion(this.status);
                continue;
            }
            catch (Throwable throwable) {
                if (!DUMP_AFTER_COMPLETION_ERRORS) continue;
                throwable.printStackTrace(System.out);
            }
        }
    }

    public void rollbackConnection() throws SQLException {
        if (this.connection != null) {
            this.debug("TxImpl - rolling back connection");
            this.status = 9;
            this.connection.rollback();
            this.status = 4;
        }
    }

    public void commitConnection() throws SQLException {
        if (this.connection != null) {
            this.debug("TxImpl - committing connection");
            this.status = 8;
            this.connection.commit();
            this.status = 3;
        }
    }

    public void cleanup() {
        this.debug("TxImpl - cleanup");
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
        this.status = 6;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Object object = null;
        this.debug("TxImpl - commit");
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                object = new ExceptionFactory().txMarkedForRollbackException();
                break;
            }
            default: {
                throw new ExceptionFactory().invalidStateException(this.status);
            }
        }
        if (object == null) {
            try {
                this.debug("TxImpl - invoking beforeCompletion");
                int n = this.listeners.size();
                for (int i = 0; i < n; ++i) {
                    ((Synchronization)this.listeners.elementAt(i)).beforeCompletion();
                }
            }
            catch (Exception exception) {
                object = exception;
                this.status = 9;
                this.debug("TxImpl - error in beforeCompletion: " + exception);
            }
        }
        if (object == null && this.status == 0) {
            try {
                this.commitConnection();
            }
            catch (Exception exception) {
                object = exception;
            }
        } else {
            try {
                this.rollbackConnection();
            }
            catch (Exception exception) {
                object = exception;
            }
        }
        this.invokeAfterCompletion();
        this.cleanup();
        if (object != null) {
            throw new ExceptionFactory().newSystemException((Exception)object);
        }
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        this.debug("TxImpl - registering sync listener: " + synchronization);
        this.listeners.add(synchronization);
    }

    public void rollback() throws IllegalStateException, SystemException {
        Exception exception = null;
        this.debug("TxImpl - rollback");
        try {
            this.rollbackConnection();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.invokeAfterCompletion();
        this.cleanup();
        if (exception != null) {
            throw new ExceptionFactory().newSystemException(exception);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.debug("TxImpl - setRollbackOnly");
        this.status = 1;
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        return false;
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        return false;
    }
}

