/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.container.Sniffer;
import org.glassfish.deployment.common.AnnotationScanner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnifferAnnotationScanner
extends AnnotationScanner {
    Map<String, List<SnifferStatus>> annotations = new HashMap<String, List<SnifferStatus>>();

    public void register(Sniffer sniffer, Class[] annotationClasses) {
        SnifferStatus stat = new SnifferStatus(sniffer);
        if (annotationClasses != null) {
            for (Class annClass : annotationClasses) {
                List<SnifferStatus> statList = this.annotations.get(Type.getDescriptor((Class)annClass));
                if (statList == null) {
                    statList = new ArrayList<SnifferStatus>();
                    this.annotations.put(Type.getDescriptor((Class)annClass), statList);
                }
                statList.add(stat);
            }
        }
    }

    public List<Sniffer> getApplicableSniffers() {
        ArrayList<Sniffer> appSniffers = new ArrayList<Sniffer>();
        for (String annotationName : this.annotations.keySet()) {
            List<SnifferStatus> statList = this.annotations.get(annotationName);
            for (SnifferStatus stat : statList) {
                if (appSniffers.contains(stat.sniffer) || !stat.found) continue;
                appSniffers.add(stat.sniffer);
            }
        }
        return appSniffers;
    }

    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        List<SnifferStatus> statusList = this.annotations.get(s);
        if (statusList != null) {
            for (SnifferStatus status : statusList) {
                status.found = true;
            }
        }
        return null;
    }

    private static final class SnifferStatus {
        Sniffer sniffer;
        boolean found;

        SnifferStatus(Sniffer sniffer) {
            this.sniffer = sniffer;
        }
    }
}

