/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.ResourceAdapterConfigManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-resource-adapter-config")
@Scoped(value=PerLookup.class)
@I18n(value="create.resource.adapter.config")
public class CreateResourceAdapterConfig
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateResourceAdapterConfig.class);
    @Param(name="raname", primary=true)
    String raName;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(name="threadpoolid", optional=true)
    String threadPoolIds;
    @Param(name="objecttype", defaultValue="user", optional=true)
    String objectType;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("resource-adapter-name", this.raName);
        attrList.put("thread-pool-ids", this.threadPoolIds);
        attrList.put("object-type", this.objectType);
        ResourceAdapterConfigManager resAdapterConfigMgr = new ResourceAdapterConfigManager();
        try {
            rs = resAdapterConfigMgr.create(this.resources, attrList, this.properties, targetServer);
        }
        catch (Exception ex) {
            Logger.getLogger(CreateResourceAdapterConfig.class.getName()).log(Level.SEVERE, "Unable to create resource adapter config for " + this.raName, ex);
            String def = "Resource adapter config: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.resource.adapter.config.fail", def, new Object[]{this.raName}) + " " + ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            } else {
                report.setMessage(localStrings.getLocalString("create.resource.adapter.config.fail", "Resource adapter config {0} creation failed", new Object[]{this.raName, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

