/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletFilterMappingDescriptor
extends Descriptor
implements ServletFilterMapping {
    public static final String TARGET_TYPE_URLPATTERN = "URLPattern";
    public static final String TARGET_TYPE_SERVLET = "Servlet";
    private static EnumSet allowed_dispatchers;
    private String targetType = "URLPattern";
    private String target = "";
    private EnumSet dispatchers;
    private List<String> servletNames;
    private List<String> urlPatterns;

    public ServletFilterMappingDescriptor() {
        super("", "");
    }

    public ServletFilterMappingDescriptor(ServletFilterMappingDescriptor other) {
        super(other);
        this.targetType = other.targetType;
        this.target = other.target;
        this.dispatchers = other.dispatchers != null ? EnumSet.copyOf(other.dispatchers) : null;
    }

    public ServletFilterMappingDescriptor(String dispName, String targetType, String target) {
        super(dispName, "");
        this.setTargetType(targetType);
        this.setTarget(target);
    }

    @Override
    public void setTargetType(String type) {
        this.targetType = TARGET_TYPE_SERVLET.equals(type) ? TARGET_TYPE_SERVLET : TARGET_TYPE_URLPATTERN;
    }

    @Override
    public String getTargetType() {
        if (!this.getServletNames().isEmpty()) {
            return TARGET_TYPE_SERVLET;
        }
        return TARGET_TYPE_URLPATTERN;
    }

    @Override
    public boolean isURLPatternTarget() {
        return TARGET_TYPE_URLPATTERN.equals(this.getTargetType());
    }

    @Override
    public boolean isServletNameTarget() {
        return TARGET_TYPE_SERVLET.equals(this.getTargetType());
    }

    @Override
    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public String getTarget() {
        if (!this.getServletNames().isEmpty()) {
            Iterator<String> i = this.servletNames.iterator();
            return i.next();
        }
        Iterator<String> i = this.urlPatterns.iterator();
        return i.next();
    }

    @Override
    public void addServletName(String servletName) {
        this.getServletNames().add(servletName);
    }

    @Override
    public List<String> getServletNames() {
        if (this.servletNames == null) {
            this.servletNames = new LinkedList<String>();
        }
        return this.servletNames;
    }

    @Override
    public void addURLPattern(String urlPattern) {
        this.getURLPatterns().add(urlPattern);
    }

    @Override
    public List<String> getURLPatterns() {
        if (this.urlPatterns == null) {
            this.urlPatterns = new LinkedList<String>();
        }
        return this.urlPatterns;
    }

    @Override
    public void addDispatcher(String dispatcher) {
        if (this.dispatchers == null) {
            this.dispatchers = EnumSet.noneOf(DispatcherType.class);
        }
        this.dispatchers.add(Enum.valueOf(DispatcherType.class, dispatcher));
    }

    public void removeDispatcher(String dispatcher) {
        if (this.dispatchers == null) {
            return;
        }
        this.dispatchers.remove((Object)Enum.valueOf(DispatcherType.class, dispatcher));
    }

    @Override
    public Set<DispatcherType> getDispatchers() {
        if (this.dispatchers == null) {
            this.dispatchers = EnumSet.noneOf(DispatcherType.class);
        }
        return this.dispatchers;
    }

    public static Set<DispatcherType> getAllowedDispatchers() {
        if (allowed_dispatchers == null) {
            allowed_dispatchers = EnumSet.allOf(DispatcherType.class);
        }
        return allowed_dispatchers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServletFilterMapping) {
            ServletFilterMapping o = (ServletFilterMapping)obj;
            if (this.getName().equals(o.getName()) && ((Object)this.getServletNames()).equals(o.getServletNames()) && ((Object)this.getURLPatterns()).equals(o.getURLPatterns())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + ((Object)this.getServletNames()).hashCode();
        result = 37 * result + ((Object)this.getURLPatterns()).hashCode();
        return result;
    }
}

