/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.Connector;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.ietf.jgss.GSSCredential;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AuthenticationMechanismHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);
    protected Logger logger = AnnotationUtils.getLogger();

    public Class<? extends Annotation> getAnnotationType() {
        return AuthenticationMechanism.class;
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        AuthenticationMechanism authMechanism = (AuthenticationMechanism)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            boolean isConnectionDefinition = this.hasConnectorAnnotation(element);
            if (isConnectionDefinition) {
                OutboundResourceAdapter ora;
                RarBundleContext rarContext = (RarBundleContext)aeHandler;
                ConnectorDescriptor desc = rarContext.getDescriptor();
                if (!desc.getOutBoundDefined()) {
                    ora = new OutboundResourceAdapter();
                    desc.setOutboundResourceAdapter(ora);
                }
                ora = desc.getOutboundResourceAdapter();
                String description = authMechanism.description();
                int authMechanismValue = this.getAuthMechVal(authMechanism.authMechanism());
                AuthenticationMechanism.CredentialInterface ci = authMechanism.credentialInterface();
                String credentialInterface = this.getCredentialInterfaceName(ci);
                AuthMechanism auth = new AuthMechanism(description, authMechanismValue, credentialInterface);
                ora.addAuthMechanism(auth);
            } else {
                this.getFailureResult(element, "Not a @Connector annotation : @AuthenticationMechanism must be specified along with @Connector annotation", true);
            }
        } else {
            this.getFailureResult(element, "Not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    private String getCredentialInterfaceName(AuthenticationMechanism.CredentialInterface ci) {
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.GenericCredential)) {
            return GenericCredential.class.getName();
        }
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.GSSCredential)) {
            return GSSCredential.class.getName();
        }
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.PasswordCredential)) {
            return PasswordCredential.class.getName();
        }
        throw new RuntimeException("Invalid credential interface :  " + ci);
    }

    private boolean hasConnectorAnnotation(AnnotationInfo element) {
        Class c = (Class)element.getAnnotatedElement();
        return c.getAnnotation(Connector.class) != null;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getConnectorAnnotationTypes();
    }

    @Override
    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    public int getAuthMechVal(String value) {
        int authMechVal;
        if (value.trim().equals("BasicPassword")) {
            authMechVal = 0;
        } else if (value.trim().equals("Kerbv5")) {
            authMechVal = 1;
        } else {
            throw new IllegalArgumentException("Invalid auth-mech-type");
        }
        return authMechVal;
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            this.logger.log(Level.WARNING, "failed to handle annotation [ " + element.getAnnotation() + " ]" + " on class [ " + className + " ], reason : " + message);
        }
        return result;
    }
}

