/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebFragmentDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationUtils;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="war")
@Scoped(value=PerLookup.class)
public class WarScanner
extends ModuleScanner<WebBundleDescriptor> {
    public void process(File archiveFile, WebBundleDescriptor webBundleDesc, ClassLoader classLoader) throws IOException {
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archiveFile);
            AnnotationUtils.getLogger().fine("webBundle is " + webBundleDesc);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        this.archiveFile = archiveFile;
        this.classLoader = classLoader;
        if (!archiveFile.isDirectory()) {
            return;
        }
        File webinf = new File(archiveFile, "WEB-INF");
        if (webBundleDesc instanceof WebFragmentDescriptor) {
            File jarFile;
            WebFragmentDescriptor webFragmentDesc = (WebFragmentDescriptor)webBundleDesc;
            File lib = new File(webinf, "lib");
            if (lib.exists() && (jarFile = new File(lib, webFragmentDesc.getJarName())).exists() && !jarFile.isDirectory()) {
                this.addScanJar(jarFile);
            }
        } else {
            File classes = new File(webinf, "classes");
            if (classes.exists()) {
                this.addScanDirectory(classes);
            }
        }
        for (WebComponentDescriptor webCompDesc : webBundleDesc.getWebComponentDescriptors()) {
            if (!webCompDesc.isServlet()) continue;
            this.addScanClassName(webCompDesc.getWebComponentImplementation());
        }
        Vector<ServletFilter> servletFilters = webBundleDesc.getServletFilters();
        for (int i = 0; i < servletFilters.size(); ++i) {
            ServletFilter filter = servletFilters.elementAt(i);
            this.addScanClassName(filter.getClassName());
        }
        Vector<AppListenerDescriptor> listeners = webBundleDesc.getAppListenerDescriptors();
        for (int j = 0; j < listeners.size(); ++j) {
            AppListenerDescriptor listenerDesc = listeners.elementAt(j);
            this.addScanClassName(listenerDesc.getListener());
        }
    }
}

