/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import java.util.Set;
import java.util.logging.Level;

public class ComponentValidator
extends DefaultDOLVisitor
implements ComponentVisitor {
    public void accept(MessageDestinationReferencer msgDestReferencer) {
        if (msgDestReferencer.isLinkedToMessageDestination()) {
            return;
        }
        if (msgDestReferencer.ownedByMessageDestinationRef() && msgDestReferencer.getMessageDestinationRefOwner().getJndiName() != null) {
            return;
        }
        MessageDestinationDescriptor msgDest = msgDestReferencer.resolveLinkName();
        if (msgDest == null) {
            String linkName = msgDestReferencer.getMessageDestinationLinkName();
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{"message-destination", linkName});
        }
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        Set portsInfo = serviceRef.getPortsInfo();
        for (ServiceRefPortInfo next : portsInfo) {
            WebServiceEndpoint portComponentLink;
            if (!next.hasPortComponentLinkName() || next.isLinkedToPortComponent() || (portComponentLink = next.resolveLinkName()) != null) continue;
            String linkName = next.getPortComponentLinkName();
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{"port-component", linkName});
        }
    }
}

