/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class DescriptorEventManager
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected Vector eventSelectors = NonSynchronizedVector.newInstance(18);
    protected transient Vector eventMethods = NonSynchronizedVector.newInstance(18);
    protected transient Vector eventListeners;
    protected transient Vector defaultEventListeners;
    protected transient Vector entityListenerEventListeners;
    protected transient DescriptorEventListener entityEventListener;
    protected transient Vector entityEventManagers;
    protected transient Vector entityListenerEventManagers;
    protected boolean excludeDefaultListeners = false;
    protected boolean excludeSuperclassListeners = false;
    protected boolean hasAnyEventListeners = false;
    public static final int PreWriteEvent = 0;
    public static final int PostWriteEvent = 1;
    public static final int PreDeleteEvent = 2;
    public static final int PostDeleteEvent = 3;
    public static final int PreInsertEvent = 4;
    public static final int PostInsertEvent = 5;
    public static final int PreUpdateEvent = 6;
    public static final int PostUpdateEvent = 7;
    public static final int PostBuildEvent = 8;
    public static final int PostRefreshEvent = 9;
    public static final int PostCloneEvent = 10;
    public static final int PostMergeEvent = 11;
    public static final int AboutToInsertEvent = 12;
    public static final int AboutToUpdateEvent = 13;
    public static final int AboutToDeleteEvent = 14;
    public static final int PrePersistEvent = 15;
    public static final int PreRemoveEvent = 16;
    public static final int PreUpdateWithChangesEvent = 17;
    protected static final int NumberOfEvents = 18;

    public DescriptorEventManager() {
        for (int i = 0; i < 18; ++i) {
            this.eventSelectors.addElement(null);
            this.eventMethods.addElement(null);
        }
    }

    public void addDefaultEventListener(DescriptorEventListener descriptorEventListener) {
        this.getDefaultEventListeners().addElement(descriptorEventListener);
    }

    public void addEntityListenerEventListener(DescriptorEventListener descriptorEventListener) {
        this.getEntityListenerEventListeners().addElement(descriptorEventListener);
    }

    public void addListener(DescriptorEventListener descriptorEventListener) {
        this.getEventListeners().addElement(descriptorEventListener);
        this.setHasAnyEventListeners(true);
    }

    public Object clone() {
        DescriptorEventManager descriptorEventManager = null;
        try {
            descriptorEventManager = (DescriptorEventManager)super.clone();
            descriptorEventManager.setEventSelectors((Vector)this.getEventSelectors().clone());
            descriptorEventManager.setEventMethods((Vector)this.getEventMethods().clone());
            descriptorEventManager.setEventListeners(this.getEventListeners());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return descriptorEventManager;
    }

    public boolean excludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    public boolean excludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeEvent(DescriptorEvent descriptorEvent) throws DescriptorException {
        block15: {
            try {
                descriptorEvent.getSession().startOperationProfile("DescriptorEvents");
                descriptorEvent.setDescriptor(this.getDescriptor());
                this.notifyListeners(descriptorEvent);
                this.notifyEJB30Listeners(descriptorEvent);
                if (descriptorEvent.getSource() instanceof DescriptorEventListener) {
                    this.notifyListener((DescriptorEventListener)descriptorEvent.getSource(), descriptorEvent);
                    return;
                }
                Method method = (Method)this.getEventMethods().elementAt(descriptorEvent.getEventCode());
                if (method == null) {
                    return;
                }
                try {
                    Object[] objectArray = new Object[]{descriptorEvent};
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, descriptorEvent.getSource(), objectArray));
                            break block15;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            if (exception instanceof IllegalAccessException) {
                                throw DescriptorException.illegalAccessWhileEventExecution(method.getName(), this.getDescriptor(), exception);
                            }
                            throw DescriptorException.targetInvocationWhileEventExecution(method.getName(), this.getDescriptor(), exception);
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(method, descriptorEvent.getSource(), objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.illegalAccessWhileEventExecution(method.getName(), this.getDescriptor(), illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DescriptorException.illegalArgumentWhileObsoleteEventExecute(method.getName(), this.getDescriptor(), illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw DescriptorException.targetInvocationWhileEventExecution(method.getName(), this.getDescriptor(), invocationTargetException);
                }
            }
            finally {
                descriptorEvent.getSession().endOperationProfile("DescriptorEvents");
            }
        }
    }

    protected Method findMethod(int n) throws DescriptorException {
        Class[] classArray = new Class[]{ClassConstants.DescriptorEvent_Class};
        String string = (String)this.getEventSelectors().elementAt(n);
        try {
            return Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw DescriptorException.noSuchMethodOnFindObsoleteMethod(string, this.getDescriptor(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityOnFindMethod(string, this.getDescriptor(), securityException);
        }
    }

    public String getAboutToInsertSelector() {
        return (String)this.getEventSelectors().elementAt(12);
    }

    public String getAboutToUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(13);
    }

    public Vector getDefaultEventListeners() {
        if (this.defaultEventListeners == null) {
            this.defaultEventListeners = new Vector();
        }
        return this.defaultEventListeners;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DescriptorEventListener getEntityEventListener() {
        return this.entityEventListener;
    }

    public Vector getEntityListenerEventListeners() {
        if (this.entityListenerEventListeners == null) {
            this.entityListenerEventListeners = new Vector();
        }
        return this.entityListenerEventListeners;
    }

    public Vector getEventListeners() {
        if (this.eventListeners == null) {
            this.eventListeners = NonSynchronizedVector.newInstance(1);
        }
        return this.eventListeners;
    }

    protected Vector getEventMethods() {
        if (this.eventMethods == null) {
            this.eventMethods = NonSynchronizedVector.newInstance(18);
            for (int i = 0; i < 18; ++i) {
                this.eventMethods.addElement(null);
            }
        }
        return this.eventMethods;
    }

    protected Vector getEventSelectors() {
        if (this.eventSelectors == null) {
            this.eventSelectors = NonSynchronizedVector.newInstance(18);
            for (int i = 0; i < 18; ++i) {
                this.eventSelectors.addElement(null);
            }
        }
        return this.eventSelectors;
    }

    public String getPostBuildSelector() {
        return (String)this.getEventSelectors().elementAt(8);
    }

    public String getPostCloneSelector() {
        return (String)this.getEventSelectors().elementAt(10);
    }

    public String getPostDeleteSelector() {
        return (String)this.getEventSelectors().elementAt(3);
    }

    public String getPostInsertSelector() {
        return (String)this.getEventSelectors().elementAt(5);
    }

    public String getPostMergeSelector() {
        return (String)this.getEventSelectors().elementAt(11);
    }

    public String getPostRefreshSelector() {
        return (String)this.getEventSelectors().elementAt(9);
    }

    public String getPostUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(7);
    }

    public String getPostWriteSelector() {
        return (String)this.getEventSelectors().elementAt(1);
    }

    public String getPrePersistSelector() {
        return (String)this.getEventSelectors().elementAt(15);
    }

    public String getPreDeleteSelector() {
        return (String)this.getEventSelectors().elementAt(2);
    }

    public String getPreInsertSelector() {
        return (String)this.getEventSelectors().elementAt(4);
    }

    public String getPreRemoveSelector() {
        return (String)this.getEventSelectors().elementAt(16);
    }

    public String getPreUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(6);
    }

    public String getPreWriteSelector() {
        return (String)this.getEventSelectors().elementAt(0);
    }

    public boolean hasAnyEventListeners() {
        return this.hasAnyEventListeners || this.hasAnyListeners();
    }

    protected boolean hasAnyListeners() {
        return this.eventListeners != null && !this.eventListeners.isEmpty();
    }

    public boolean hasEntityEventListener() {
        return this.entityEventListener != null;
    }

    public boolean hasEntityListenerEventListeners() {
        return this.entityListenerEventListeners != null && this.entityListenerEventListeners.size() > 0;
    }

    public void initialize(AbstractSession abstractSession) {
        this.initializeEJB30EventManagers();
        if (this.hasEntityEventListener() || this.hasEntityListenerEventListeners()) {
            this.setHasAnyEventListeners(true);
        }
        if (this.hasAnyListeners() || DescriptorEventListener.class.isAssignableFrom(this.getDescriptor().getJavaClass())) {
            this.setHasAnyEventListeners(true);
        }
        for (int i = 0; i < 18; ++i) {
            if (this.getEventSelectors().elementAt(i) == null) continue;
            this.setHasAnyEventListeners(true);
            this.getEventMethods().setElementAt(this.findMethod(i), i);
        }
        if (this.getDescriptor().isChildDescriptor()) {
            DescriptorEventManager descriptorEventManager = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager();
            if (descriptorEventManager.hasAnyEventListeners()) {
                this.setHasAnyEventListeners(true);
            }
            for (int i = 0; i < 18; ++i) {
                if (this.getEventSelectors().get(i) != null || descriptorEventManager.getEventSelectors().get(i) == null) continue;
                this.setHasAnyEventListeners(true);
                this.getEventSelectors().set(i, descriptorEventManager.getEventSelectors().get(i));
                this.getEventMethods().set(i, descriptorEventManager.getEventMethods().get(i));
            }
        }
    }

    protected void initializeEJB30EventManagers() {
        this.entityEventManagers = new Vector();
        this.entityListenerEventManagers = new Vector();
        if (this.hasEntityEventListener()) {
            this.entityEventManagers.add(this);
        }
        if (this.hasEntityListenerEventListeners()) {
            this.entityListenerEventManagers.add(this);
        }
        ClassDescriptor classDescriptor = this.getDescriptor();
        boolean bl = this.excludeSuperclassListeners();
        while (classDescriptor.isChildDescriptor()) {
            DescriptorEventManager descriptorEventManager = (classDescriptor = classDescriptor.getInheritancePolicy().getParentDescriptor()).getEventManager();
            if (descriptorEventManager.hasEntityEventListener()) {
                this.entityEventManagers.add(descriptorEventManager);
            }
            if (descriptorEventManager.hasEntityListenerEventListeners() && !bl) {
                this.entityListenerEventManagers.add(descriptorEventManager);
            }
            bl = descriptorEventManager.excludeSuperclassListeners();
        }
    }

    protected void notifyEJB30Listeners(DescriptorEvent descriptorEvent) {
        Object object;
        int n;
        if (!this.excludeDefaultListeners()) {
            for (n = 0; n < this.getDefaultEventListeners().size(); ++n) {
                object = (DescriptorEventListener)this.getDefaultEventListeners().get(n);
                this.notifyListener((DescriptorEventListener)object, descriptorEvent);
            }
        }
        for (n = this.entityListenerEventManagers.size() - 1; n >= 0; --n) {
            object = ((DescriptorEventManager)this.entityListenerEventManagers.get(n)).getEntityListenerEventListeners();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                DescriptorEventListener descriptorEventListener = (DescriptorEventListener)((Vector)object).get(i);
                this.notifyListener(descriptorEventListener, descriptorEvent);
            }
        }
        for (n = this.entityEventManagers.size() - 1; n >= 0; --n) {
            object = ((DescriptorEventManager)this.entityEventManagers.get(n)).getEntityEventListener();
            if (object.isOverriddenEvent(descriptorEvent, this.entityEventManagers)) continue;
            this.notifyListener((DescriptorEventListener)object, descriptorEvent);
        }
    }

    protected void notifyListener(DescriptorEventListener descriptorEventListener, DescriptorEvent descriptorEvent) throws DescriptorException {
        switch (descriptorEvent.getEventCode()) {
            case 0: {
                descriptorEventListener.preWrite(descriptorEvent);
                break;
            }
            case 1: {
                descriptorEventListener.postWrite(descriptorEvent);
                break;
            }
            case 2: {
                descriptorEventListener.preDelete(descriptorEvent);
                break;
            }
            case 3: {
                descriptorEventListener.postDelete(descriptorEvent);
                break;
            }
            case 4: {
                descriptorEventListener.preInsert(descriptorEvent);
                break;
            }
            case 5: {
                descriptorEventListener.postInsert(descriptorEvent);
                break;
            }
            case 6: {
                descriptorEventListener.preUpdate(descriptorEvent);
                break;
            }
            case 7: {
                descriptorEventListener.postUpdate(descriptorEvent);
                break;
            }
            case 11: {
                descriptorEventListener.postMerge(descriptorEvent);
                break;
            }
            case 10: {
                descriptorEventListener.postClone(descriptorEvent);
                break;
            }
            case 8: {
                descriptorEventListener.postBuild(descriptorEvent);
                break;
            }
            case 9: {
                descriptorEventListener.postRefresh(descriptorEvent);
                break;
            }
            case 12: {
                descriptorEventListener.aboutToInsert(descriptorEvent);
                break;
            }
            case 13: {
                descriptorEventListener.aboutToUpdate(descriptorEvent);
                break;
            }
            case 14: {
                descriptorEventListener.aboutToDelete(descriptorEvent);
                break;
            }
            case 15: {
                descriptorEventListener.prePersist(descriptorEvent);
                break;
            }
            case 16: {
                descriptorEventListener.preRemove(descriptorEvent);
                break;
            }
            case 17: {
                descriptorEventListener.preUpdateWithChanges(descriptorEvent);
                break;
            }
            default: {
                throw DescriptorException.invalidDescriptorEventCode(descriptorEvent, this.getDescriptor());
            }
        }
    }

    public void notifyListeners(DescriptorEvent descriptorEvent) {
        if (this.hasAnyListeners()) {
            for (int i = 0; i < this.getEventListeners().size(); ++i) {
                DescriptorEventListener descriptorEventListener = (DescriptorEventListener)this.getEventListeners().get(i);
                this.notifyListener(descriptorEventListener, descriptorEvent);
            }
        }
        if (this.getDescriptor().isChildDescriptor()) {
            this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager().notifyListeners(descriptorEvent);
        }
    }

    public void remoteInitialization(AbstractSession abstractSession) {
        this.eventMethods = new Vector(18);
        for (int i = 0; i < 18; ++i) {
            this.eventMethods.addElement(null);
        }
        this.initialize(abstractSession);
    }

    public void removeListener(DescriptorEventListener descriptorEventListener) {
        this.getEventListeners().removeElement(descriptorEventListener);
    }

    public void setAboutToInsertSelector(String string) {
        this.getEventSelectors().setElementAt(string, 12);
    }

    public void setAboutToUpdateSelector(String string) {
        this.getEventSelectors().setElementAt(string, 13);
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setEntityEventListener(DescriptorEventListener descriptorEventListener) {
        this.entityEventListener = descriptorEventListener;
    }

    protected void setEventListeners(Vector vector) {
        this.eventListeners = vector;
    }

    protected void setEventMethods(Vector vector) {
        this.eventMethods = vector;
    }

    protected void setEventSelectors(Vector vector) {
        this.eventSelectors = vector;
    }

    public void setExcludeDefaultListeners(boolean bl) {
        this.excludeDefaultListeners = bl;
    }

    public void setExcludeSuperclassListeners(boolean bl) {
        this.excludeSuperclassListeners = bl;
    }

    protected void setHasAnyEventListeners(boolean bl) {
        this.hasAnyEventListeners = bl;
    }

    public void setPostBuildSelector(String string) {
        this.getEventSelectors().setElementAt(string, 8);
    }

    public void setPostCloneSelector(String string) {
        this.getEventSelectors().setElementAt(string, 10);
    }

    public void setPostDeleteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 3);
    }

    public void setPostInsertSelector(String string) {
        this.getEventSelectors().setElementAt(string, 5);
    }

    public void setPostMergeSelector(String string) {
        this.getEventSelectors().setElementAt(string, 11);
    }

    public void setPostRefreshSelector(String string) {
        this.getEventSelectors().setElementAt(string, 9);
    }

    public void setPostUpdateSelector(String string) {
        this.getEventSelectors().setElementAt(string, 7);
    }

    public void setPostWriteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 1);
    }

    public void setPreDeleteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 2);
    }

    public void setPreInsertSelector(String string) {
        this.getEventSelectors().setElementAt(string, 4);
    }

    public void setPrePersistSelector(String string) {
        this.getEventSelectors().setElementAt(string, 15);
    }

    public void setPreRemoveSelector(String string) {
        this.getEventSelectors().setElementAt(string, 16);
    }

    public void setPreUpdateSelector(String string) {
        this.getEventSelectors().setElementAt(string, 6);
    }

    public void setPreWriteSelector(String string) {
        this.getEventSelectors().setElementAt(string, 0);
    }
}

