/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ClassExtractor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class MethodClassExtractor
extends ClassExtractor {
    protected transient ClassDescriptor descriptor;
    protected String classExtractionMethodName;
    protected transient Method classExtractionMethod;

    public Method getClassExtractionMethod() {
        return this.classExtractionMethod;
    }

    public String getClassExtractionMethodName() {
        return this.classExtractionMethodName;
    }

    protected void setClassExtractionMethod(Method method) {
        this.classExtractionMethod = method;
    }

    public void setClassExtractionMethodName(String string) {
        this.classExtractionMethodName = string;
    }

    public void initialize(ClassDescriptor classDescriptor, Session session) throws DescriptorException {
        this.setDescriptor(classDescriptor);
        Class[] classArray = new Class[]{ClassConstants.DatabaseRow_Class};
        try {
            this.setClassExtractionMethod(Helper.getDeclaredMethod(classDescriptor.getJavaClass(), this.getClassExtractionMethodName(), classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classArray[0] = ClassConstants.Record_Class;
            try {
                this.setClassExtractionMethod(Helper.getDeclaredMethod(classDescriptor.getJavaClass(), this.getClassExtractionMethodName(), classArray));
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw DescriptorException.noSuchMethodWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), classDescriptor, noSuchMethodException2);
            }
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), classDescriptor, securityException);
        }
        if (!Modifier.isStatic(this.getClassExtractionMethod().getModifiers())) {
            throw DescriptorException.classExtractionMethodMustBeStatic(this.getClassExtractionMethodName(), classDescriptor);
        }
    }

    public Class extractClassFromRow(Record record, Session session) {
        Class clazz;
        block7: {
            try {
                Object[] objectArray = new Object[]{record};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getClassExtractionMethod(), null, objectArray));
                        break block7;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)record, this.getClassExtractionMethod(), this.getDescriptor(), exception);
                        }
                        throw DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((AbstractRecord)record, this.getClassExtractionMethod(), this.getDescriptor(), exception);
                    }
                }
                clazz = (Class)PrivilegedAccessHelper.invokeMethod(this.getClassExtractionMethod(), null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)record, this.getClassExtractionMethod(), this.getDescriptor(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((AbstractRecord)record, this.getClassExtractionMethod(), this.getDescriptor(), invocationTargetException);
            }
        }
        return clazz;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }
}

