/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InterfacePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class TablePerClassPolicy
extends InterfacePolicy
implements Serializable,
Cloneable {
    protected HashMap<DatabaseMapping, DatabaseQuery> selectionQueriesForAllObjects;

    public TablePerClassPolicy(ClassDescriptor classDescriptor) {
        this.setDescriptor(classDescriptor);
        this.selectionQueriesForAllObjects = new HashMap();
    }

    protected void addSelectionQuery(ForeignReferenceMapping foreignReferenceMapping, ForeignReferenceMapping foreignReferenceMapping2, AbstractSession abstractSession) {
        foreignReferenceMapping.setReferenceClass(this.getDescriptor().getJavaClass());
        foreignReferenceMapping.setReferenceClassName(this.getDescriptor().getJavaClassName());
        foreignReferenceMapping.setForceInitializationOfSelectionCriteria(true);
        foreignReferenceMapping.initialize(abstractSession);
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)foreignReferenceMapping.getSelectionQuery();
        objectLevelReadQuery.getExpressionBuilder().setQueryClassAndDescriptor(this.descriptor.getJavaClass(), this.descriptor);
        objectLevelReadQuery.setSourceMapping(foreignReferenceMapping2);
        this.selectionQueriesForAllObjects.put(foreignReferenceMapping2, objectLevelReadQuery);
    }

    public boolean isTablePerClassPolicy() {
        return true;
    }

    public void prepareChildrenSelectionQuery(DatabaseMapping databaseMapping, AbstractSession abstractSession) {
        for (ClassDescriptor classDescriptor : this.getChildDescriptors()) {
            classDescriptor.getTablePerClassPolicy().prepareSelectionQuery(databaseMapping, abstractSession);
        }
    }

    protected void prepareManyToManySelectionQuery(ManyToManyMapping manyToManyMapping, AbstractSession abstractSession) {
        ManyToManyMapping manyToManyMapping2 = (ManyToManyMapping)manyToManyMapping.clone();
        for (DatabaseField databaseField : manyToManyMapping2.getTargetKeyFields()) {
            databaseField.setTable(new DatabaseTable());
        }
        this.addSelectionQuery(manyToManyMapping2, manyToManyMapping, abstractSession);
    }

    protected void prepareOneToManySelectionQuery(OneToManyMapping oneToManyMapping, AbstractSession abstractSession) {
        OneToManyMapping oneToManyMapping2 = (OneToManyMapping)oneToManyMapping.clone();
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        for (DatabaseField databaseField : oneToManyMapping2.getTargetForeignKeysToSourceKeys().keySet()) {
            vector.add(new DatabaseField(databaseField.getName()));
        }
        oneToManyMapping2.setTargetForeignKeyFields(vector);
        oneToManyMapping2.getTargetForeignKeysToSourceKeys().clear();
        oneToManyMapping2.getSourceKeysToTargetForeignKeys().clear();
        this.addSelectionQuery(oneToManyMapping2, oneToManyMapping, abstractSession);
    }

    protected void prepareOneToOneSelectionQuery(OneToOneMapping oneToOneMapping, AbstractSession abstractSession) {
        OneToOneMapping oneToOneMapping2 = (OneToOneMapping)oneToOneMapping.clone();
        for (DatabaseField databaseField : oneToOneMapping2.getTargetToSourceKeyFields().keySet()) {
            databaseField.setTable(new DatabaseTable());
        }
        this.addSelectionQuery(oneToOneMapping2, oneToOneMapping, abstractSession);
    }

    protected void prepareSelectionQuery(DatabaseMapping databaseMapping, AbstractSession abstractSession) {
        for (ClassDescriptor classDescriptor : this.getChildDescriptors()) {
            classDescriptor.getTablePerClassPolicy().prepareSelectionQuery(databaseMapping, abstractSession);
        }
        if (databaseMapping.isOneToManyMapping()) {
            this.prepareOneToManySelectionQuery((OneToManyMapping)databaseMapping, abstractSession);
        } else if (databaseMapping.isManyToManyMapping()) {
            this.prepareManyToManySelectionQuery((ManyToManyMapping)databaseMapping, abstractSession);
        } else if (databaseMapping.isOneToOneMapping()) {
            this.prepareOneToOneSelectionQuery((OneToOneMapping)databaseMapping, abstractSession);
        }
    }

    protected Object selectAllObjects(ReadAllQuery readAllQuery) {
        if (this.selectionQueriesForAllObjects.containsKey(readAllQuery.getSourceMapping())) {
            return readAllQuery.getExecutionSession().executeQuery(this.selectionQueriesForAllObjects.get(readAllQuery.getSourceMapping()), readAllQuery.getTranslationRow());
        }
        return super.selectAllObjects(readAllQuery);
    }

    protected Object selectOneObject(ReadObjectQuery readObjectQuery) throws DescriptorException {
        if (this.selectionQueriesForAllObjects.containsKey(readObjectQuery.getSourceMapping())) {
            return readObjectQuery.getExecutionSession().executeQuery(this.selectionQueriesForAllObjects.get(readObjectQuery.getSourceMapping()), readObjectQuery.getTranslationRow());
        }
        AbstractRecord abstractRecord = (AbstractRecord)readObjectQuery.getTranslationRow().clone();
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        for (DatabaseField databaseField : abstractRecord.getFields()) {
            vector.add(new DatabaseField(databaseField.getName()));
        }
        abstractRecord.getFields().clear();
        abstractRecord.getFields().addAll(vector);
        return readObjectQuery.getSession().executeQuery((DatabaseQuery)this.getDescriptor().getQueryManager().getReadObjectQuery(), abstractRecord);
    }
}

