/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class IndexedInteraction
extends EISInteraction {
    public void addArgument(String string) {
        this.getArguments().addElement(new DatabaseField(string));
    }

    public void addArgumentValue(Object object) {
        this.getArguments().addElement(object);
    }

    public void addOutputArgument(String string) {
        this.getOutputArguments().addElement(new DatabaseField(string));
    }

    public Vector getArguments() {
        return super.getArguments();
    }

    public Vector getOutputArguments() {
        return super.getOutputArguments();
    }

    public void setArguments(Vector vector) {
        super.setArguments(vector);
    }

    public void setOutputArguments(Vector vector) {
        super.setOutputArguments(vector);
    }

    public Record createInputRecord(EISAccessor eISAccessor) {
        try {
            IndexedRecord indexedRecord = eISAccessor.getRecordFactory().createIndexedRecord(this.getInputRecordName());
            for (int i = 0; i < this.getParameters().size(); ++i) {
                Object e = this.getParameters().get(i);
                indexedRecord.add(this.createRecordElement("", e, eISAccessor));
            }
            return indexedRecord;
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public AbstractRecord buildRow(Record record, EISAccessor eISAccessor) {
        AbstractRecord abstractRecord = null;
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            abstractRecord = new DatabaseRecord(indexedRecord.size());
            for (int i = 0; i < indexedRecord.size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getOutputArguments().get(i);
                abstractRecord.put(databaseField, indexedRecord.get(i));
            }
        } else if (record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            if (this.getOutputArgumentNames().size() == 1) {
                mappedRecord = (MappedRecord)mappedRecord.get(this.getOutputArgumentNames().get(0));
            } else if (this.getOutputArgumentNames().size() > 1) {
                abstractRecord = new DatabaseRecord(this.getOutputArgumentNames().size());
                for (int i = 0; i < this.getOutputArgumentNames().size(); ++i) {
                    DatabaseField databaseField = (DatabaseField)this.getOutputArguments().get(i);
                    abstractRecord.put(databaseField, mappedRecord.get(this.getOutputArgumentNames().get(i)));
                }
                return abstractRecord;
            }
            abstractRecord = new EISMappedRecord((Map)mappedRecord, eISAccessor);
        } else {
            abstractRecord = new DatabaseRecord(1);
            abstractRecord.put(this.getOutputResultPath(), (Object)record);
        }
        return abstractRecord;
    }
}

