/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class BindCallCustomParameter {
    protected Object obj;

    public boolean shouldUseUnwrappedConnection() {
        return false;
    }

    public BindCallCustomParameter(Object object) {
        this.obj = object;
    }

    protected BindCallCustomParameter() {
    }

    public void set(DatabasePlatform databasePlatform, PreparedStatement preparedStatement, int n, AbstractSession abstractSession) throws SQLException {
        databasePlatform.setParameterValueInDatabaseCall(this.obj, preparedStatement, n, abstractSession);
    }

    public String toString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        return "null";
    }

    public Object convert(Object list, DatabaseField databaseField, AbstractSession abstractSession, Connection connection) throws SQLException {
        if (list == null) {
            return databaseField;
        }
        if (databaseField == null || !databaseField.isObjectRelationalDatabaseField()) {
            return list;
        }
        ObjectRelationalDatabaseField objectRelationalDatabaseField = (ObjectRelationalDatabaseField)databaseField;
        if (databaseField.getSqlType() == 2002) {
            ClassDescriptor classDescriptor;
            if (!(list instanceof Struct) && (classDescriptor = abstractSession.getDescriptor(list)) != null && classDescriptor.isObjectRelationalDataTypeDescriptor()) {
                ObjectRelationalDataTypeDescriptor objectRelationalDataTypeDescriptor = (ObjectRelationalDataTypeDescriptor)classDescriptor;
                AbstractRecord abstractRecord = objectRelationalDataTypeDescriptor.getObjectBuilder().buildRow(list, abstractSession);
                return objectRelationalDataTypeDescriptor.buildStructureFromRow(abstractRecord, abstractSession, connection);
            }
            return list;
        }
        if (list instanceof Object[]) {
            list = Arrays.asList((Object[])list);
        }
        if (databaseField.getSqlType() != 2003 || list instanceof Array || !(list instanceof Collection)) {
            return list;
        }
        Collection collection = list;
        DatabaseField databaseField2 = objectRelationalDatabaseField.getNestedTypeField();
        Object[] objectArray = new Object[collection.size()];
        int n = 0;
        for (Object object : collection) {
            if (object != null) {
                object = this.convert(object, databaseField2, abstractSession, connection);
            }
            objectArray[n++] = object;
        }
        return abstractSession.getPlatform().createArray(((ObjectRelationalDatabaseField)databaseField).getSqlTypeName(), objectArray, abstractSession, connection);
    }
}

