/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public abstract class CompoundExpression
extends Expression {
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Expression firstChild;
    protected Expression secondChild;
    protected ExpressionBuilder builder;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CompoundExpression compoundExpression = (CompoundExpression)object;
        return (this.getOperator() == compoundExpression.getOperator() || this.getOperator() != null && this.getOperator().equals(compoundExpression.getOperator())) && (this.getFirstChild() == compoundExpression.getFirstChild() || this.getFirstChild() != null && this.getFirstChild().equals(compoundExpression.getFirstChild())) && (this.getSecondChild() == compoundExpression.getSecondChild() || this.getSecondChild() != null && this.getSecondChild().equals(compoundExpression.getSecondChild()));
    }

    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.getOperator() != null) {
            n += this.getOperator().hashCode();
        }
        if (this.getFirstChild() != null) {
            n += this.getFirstChild().hashCode();
        }
        if (this.getSecondChild() != null) {
            n += this.getSecondChild().hashCode();
        }
        return n;
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        DatabaseTable databaseTable2 = null;
        if (this.getFirstChild() != null) {
            databaseTable2 = this.getFirstChild().aliasForTable(databaseTable);
        }
        if (databaseTable2 == null && this.getSecondChild() != null) {
            databaseTable2 = this.getSecondChild().aliasForTable(databaseTable);
        }
        return databaseTable2;
    }

    public Expression asOf(AsOfClause asOfClause) {
        final AsOfClause asOfClause2 = asOfClause;
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (expression.isDataExpression()) {
                    expression.asOf(asOfClause2);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        expressionIterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression expression, Object object, ExpressionOperator expressionOperator) {
        this.setFirstChild(expression);
        Expression expression2 = Expression.from(object, expression);
        this.setSecondChild(expression2);
        this.setOperator(expressionOperator);
        return this;
    }

    public Expression create(Expression expression, Vector vector, ExpressionOperator expressionOperator) {
        this.setFirstChild(expression);
        if (!vector.isEmpty()) {
            this.setSecondChild((Expression)vector.firstElement());
        }
        this.setOperator(expressionOperator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Compound Expression";
    }

    public ExpressionBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.getFirstChild().getBuilder();
            if (this.builder == null) {
                this.builder = this.getSecondChild().getBuilder();
            }
        }
        return this.builder;
    }

    public Expression getFirstChild() {
        return this.firstChild;
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform databasePlatform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(databasePlatform);
        }
        return this.platformOperator;
    }

    public Expression getSecondChild() {
        return this.secondChild;
    }

    public void initializePlatformOperator(DatabasePlatform databasePlatform) {
        if (this.getOperator().isComplete()) {
            this.platformOperator = this.getOperator();
            return;
        }
        this.platformOperator = databasePlatform.getOperator(this.getOperator().getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.getOperator().toString());
        }
    }

    public boolean isCompoundExpression() {
        return true;
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        super.iterateOn(expressionIterator);
        if (this.getFirstChild() != null) {
            this.getFirstChild().iterateOn(expressionIterator);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().iterateOn(expressionIterator);
        }
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        ExpressionBuilder expressionBuilder;
        this.validateNode();
        if (this.getFirstChild() != null) {
            expressionBuilder = this.getFirstChild().getBuilder();
            if (expressionBuilder != null) {
                expressionBuilder.setSession(expressionNormalizer.getSession().getRootSession(null));
            }
            this.setFirstChild(this.getFirstChild().normalize(expressionNormalizer));
        }
        if (this.getSecondChild() != null) {
            expressionBuilder = this.getSecondChild().getBuilder();
            if (expressionBuilder != null) {
                expressionBuilder.setSession(expressionNormalizer.getSession().getRootSession(null));
            }
            this.setSecondChild(this.getSecondChild().normalize(expressionNormalizer));
        }
        if (this.getFirstChild() == null) {
            return this.getSecondChild();
        }
        if (this.getSecondChild() == null) {
            return this.getFirstChild();
        }
        return this;
    }

    public void validateNode() {
        if (this.getFirstChild() != null && (this.getFirstChild().isDataExpression() || this.getFirstChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
        if (this.getSecondChild() != null && (this.getSecondChild().isDataExpression() || this.getSecondChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        if (this.getFirstChild() != null) {
            this.setFirstChild(this.getFirstChild().copiedVersionFrom(map));
        }
        if (this.getSecondChild() != null) {
            this.setSecondChild(this.getSecondChild().copiedVersionFrom(map));
        }
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionSQLPrinter.getPlatform());
        expressionSQLPrinter.printString("(");
        expressionOperator.printDuo(this.getFirstChild(), this.getSecondChild(), expressionSQLPrinter);
        expressionSQLPrinter.printString(")");
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionJavaPrinter.getPlatform());
        expressionOperator.printJavaDuo(this.getFirstChild(), this.getSecondChild(), expressionJavaPrinter);
    }

    public Expression rebuildOn(Expression expression) {
        NonSynchronizedVector nonSynchronizedVector;
        Expression expression2 = this.getFirstChild().rebuildOn(expression);
        if (this.getSecondChild() == null) {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(0);
        } else {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
            ((Vector)nonSynchronizedVector).addElement(this.getSecondChild().rebuildOn(expression));
        }
        return expression2.performOperator(this.getOperator(), nonSynchronizedVector);
    }

    protected void setFirstChild(Expression expression) {
        this.firstChild = expression;
        this.builder = null;
    }

    public void setOperator(ExpressionOperator expressionOperator) {
        this.operator = expressionOperator;
    }

    protected void setSecondChild(Expression expression) {
        this.secondChild = expression;
        this.builder = null;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        NonSynchronizedVector nonSynchronizedVector;
        if (this.getSecondChild() == null) {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(0);
        } else {
            nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
            ((Vector)nonSynchronizedVector).addElement(this.getSecondChild().twistedForBaseAndContext(expression, expression2));
        }
        Expression expression3 = this.getFirstChild().twistedForBaseAndContext(expression, expression2);
        return expression3.performOperator(this.getOperator(), nonSynchronizedVector);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.operator.toString());
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.getFirstChild() != null) {
            this.getFirstChild().toString(bufferedWriter, n);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().toString(bufferedWriter, n);
        }
    }

    public Expression shallowClone() {
        CompoundExpression compoundExpression = (CompoundExpression)super.shallowClone();
        compoundExpression.builder = null;
        return compoundExpression;
    }
}

