/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;

public class ExpressionJavaPrinter {
    protected StringWriter writer;
    protected String builderString;
    protected DatabasePlatform platform;

    public ExpressionJavaPrinter(String string, StringWriter stringWriter, DatabasePlatform databasePlatform) {
        this.builderString = string;
        this.writer = stringWriter;
        this.platform = databasePlatform;
    }

    public String getBuilderString() {
        return this.builderString;
    }

    public DatabasePlatform getPlatform() {
        return this.platform;
    }

    public StringWriter getWriter() {
        return this.writer;
    }

    public void printString(String string) {
        this.getWriter().write(string);
    }

    public void printJava(Object object) {
        if (object == null) {
            this.printString("null");
        } else if (object.getClass() == ClassConstants.STRING) {
            this.printString("\"");
            this.printString((String)object);
            this.printString("\"");
        } else if (object instanceof Calendar) {
            this.printString("new java.util.Date(");
            this.printString(String.valueOf(((Calendar)object).getTimeInMillis()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.TIMESTAMP) {
            this.printString("new java.sql.Timestamp(");
            this.printString(String.valueOf(((Timestamp)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.SQLDATE) {
            this.printString("new java.sql.Date(");
            this.printString(String.valueOf(((java.sql.Date)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.TIME) {
            this.printString("new java.sql.Time(");
            this.printString(String.valueOf(((Time)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            this.printString("new java.util.Date(");
            this.printString(String.valueOf(((Date)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.BYTE) {
            this.printByte((Byte)object);
        } else if (object.getClass() == ClassConstants.APBYTE) {
            this.printString("new byte[] {");
            byte[] byArray = (byte[])object;
            if (byArray.length > 0) {
                this.printString(String.valueOf(byArray[0]));
                for (int i = 1; i < byArray.length; ++i) {
                    this.printString(",");
                    this.printString(String.valueOf(byArray[i]));
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.ABYTE) {
            this.printString("new Byte[] {");
            Byte[] byteArray = (Byte[])object;
            if (byteArray.length > 0) {
                this.printByte(byteArray[0]);
                for (int i = 1; i < byteArray.length; ++i) {
                    this.printString(",");
                    this.printByte(byteArray[i]);
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.CHAR) {
            this.printCharacter((Character)object);
        } else if (object.getClass() == ClassConstants.APCHAR) {
            this.printString("new char[] {");
            char[] cArray = (char[])object;
            if (cArray.length > 0) {
                this.printString("'");
                this.printString(String.valueOf(cArray[0]));
                this.printString("'");
                for (int i = 1; i < cArray.length; ++i) {
                    this.printString(",");
                    this.printString("'");
                    this.printString(String.valueOf(cArray[i]));
                    this.printString("'");
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.ACHAR) {
            this.printString("new Character[] {");
            Character[] characterArray = (Character[])object;
            if (characterArray.length > 0) {
                this.printCharacter(characterArray[0]);
                for (int i = 1; i < characterArray.length; ++i) {
                    this.printString(",");
                    this.printCharacter(characterArray[i]);
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.BIGDECIMAL) {
            this.printString("new java.math.BigDecimal(\"");
            this.printString(((BigDecimal)object).toString());
            this.printString("\")");
        } else if (object.getClass() == ClassConstants.BIGINTEGER) {
            this.printString("new java.math.BigInteger(\"");
            this.printString(((BigInteger)object).toString());
            this.printString("\")");
        } else {
            this.printString((String)ConversionManager.getDefaultManager().convertObject(object, String.class));
        }
    }

    public void printByte(Byte by) {
        this.printString("new Byte((byte)");
        this.printString(by.toString());
        this.printString(")");
    }

    public void printCharacter(Character c) {
        this.printString("new Character('");
        this.printString(c.toString());
        this.printString("')");
    }
}

