/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.NestedTable;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryKeyExpression
extends ObjectExpression {
    protected String name;
    protected DatabaseField aliasedField;
    protected boolean shouldQueryToManyRelationship;
    protected transient QueryKey queryKey;
    protected boolean hasQueryKey;
    protected transient DatabaseMapping mapping;
    protected boolean hasMapping;
    protected Boolean isAttributeExpression;

    public QueryKeyExpression() {
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    public QueryKeyExpression(String string, Expression expression) {
        this.name = string;
        this.baseExpression = expression;
        this.shouldUseOuterJoin = false;
        this.shouldQueryToManyRelationship = false;
        this.hasQueryKey = true;
        this.hasMapping = true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)object;
        if (this.shouldQueryToManyRelationship() || queryKeyExpression.shouldQueryToManyRelationship()) {
            return false;
        }
        return this.getName() == queryKeyExpression.getName() || this.getName() != null && this.getName().equals(queryKeyExpression.getName());
    }

    @Override
    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.getName() != null) {
            n += this.getName().hashCode();
        }
        return n;
    }

    @Override
    public Expression additionalExpressionCriteria() {
        Expression expression;
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression expression2 = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (expression2 != null) {
            expression2 = this.getBaseExpression().twist(expression2, this);
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                expression2.convertToUseOuterJoin();
            }
        }
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            expression = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            expression = this.getBaseExpression().twist(expression, this);
            expression.convertToUseOuterJoin();
            expression2 = expression2 == null ? expression : expression2.and(expression);
        }
        if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null) {
            expression = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this);
            expression2 = expression2 != null ? expression2.and(expression) : expression;
        }
        return expression2;
    }

    @Override
    public Map additionalExpressionCriteriaMap() {
        Cloneable cloneable;
        if (this.getDescriptor() == null) {
            return null;
        }
        HashMap<Cloneable, Expression> hashMap = new HashMap<Cloneable, Expression>();
        Vector<DatabaseTable> vector = this.getDescriptor().getTables();
        int n = vector.size();
        if (this.shouldUseOuterJoin()) {
            for (int i = 1; i < n; ++i) {
                DatabaseTable databaseTable = vector.elementAt(i);
                cloneable = (Expression)this.getDescriptor().getQueryManager().getTablesJoinExpressions().get(databaseTable);
                cloneable = this.getBaseExpression().twist((Expression)cloneable, this);
                hashMap.put(databaseTable, (Expression)cloneable);
            }
        }
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            List list = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            n = list.size();
            for (int i = 0; i < n; ++i) {
                cloneable = (DatabaseTable)list.get(i);
                Expression expression = (Expression)this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(cloneable);
                expression = this.getBaseExpression().twist(expression, this);
                hashMap.put(cloneable, expression);
            }
        }
        return hashMap;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        DatabaseMapping databaseMapping = this.getMapping();
        if (this.isAttribute() || databaseMapping != null && (databaseMapping.isAggregateObjectMapping() || databaseMapping.isTransformationMapping())) {
            return ((DataExpression)this.getBaseExpression()).aliasForTable(databaseTable);
        }
        if (databaseMapping != null && (databaseMapping.isReferenceMapping() || databaseMapping.isStructureMapping())) {
            DatabaseTable databaseTable2 = this.getBaseExpression().aliasForTable(databaseMapping.getDescriptor().getTables().firstElement());
            databaseTable2.setName(databaseTable2.getName() + "." + databaseMapping.getField().getName());
            return databaseTable2;
        }
        if (databaseMapping != null && databaseMapping.isDirectCollectionMapping()) {
            DatabaseTable databaseTable3;
            if (this.tableAliases != null && (databaseTable3 = this.tableAliases.keyAtValue(databaseTable)) != null) {
                return databaseTable3;
            }
            return this.getTable(databaseTable).aliasForTable(databaseTable);
        }
        return super.aliasForTable(databaseTable);
    }

    @Override
    public String descriptionOfNodeType() {
        return "Query Key";
    }

    public void doQueryToManyRelationship() {
        this.shouldQueryToManyRelationship = true;
    }

    @Override
    public List<DatabaseTable> getAdditionalTables() {
        if (this.mapping != null && this.mapping.isCollectionMapping()) {
            return ((CollectionMapping)this.mapping).getContainerPolicy().getAdditionalTablesForJoinQuery();
        }
        return null;
    }

    @Override
    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    protected DatabaseTable getAliasedTable() {
        DataExpression dataExpression = (DataExpression)this.getBaseExpression();
        DatabaseTable databaseTable = dataExpression.aliasForTable(this.getField().getTable());
        if (databaseTable == null) {
            return this.getField().getTable();
        }
        return databaseTable;
    }

    public ClassDescriptor getContainingDescriptor() {
        return ((DataExpression)this.getBaseExpression()).getDescriptor();
    }

    @Override
    public DatabaseField getField() {
        if (!this.isAttribute()) {
            return null;
        }
        return this.getContainingDescriptor().getObjectBuilder().getFieldForQueryKeyName(this.getName());
    }

    @Override
    public Vector getFields() {
        if (this.isAttribute()) {
            Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
            DatabaseField databaseField = this.getField();
            if (databaseField != null) {
                vector.addElement(databaseField);
            }
            return vector;
        }
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        vector.addAll(super.getFields());
        if (this.mapping.isCollectionMapping() && this.mapping.getContainerPolicy().getAllFieldsForMapKey() != null) {
            vector.addAll(this.mapping.getContainerPolicy().getAllFieldsForMapKey());
        }
        return vector;
    }

    @Override
    public Object getFieldValue(Object vector, AbstractSession abstractSession) {
        DatabaseMapping databaseMapping = this.getMapping();
        Vector vector2 = vector;
        if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) {
            if (vector instanceof Collection) {
                Collection collection = vector;
                Vector vector3 = new Vector(collection.size());
                for (Object object : collection) {
                    if (!(object instanceof Expression)) {
                        object = this.getFieldValue(object, abstractSession);
                    }
                    vector3.add(object);
                }
                vector2 = vector3;
            } else {
                vector2 = ((AbstractDirectMapping)databaseMapping).getFieldValue(vector, abstractSession);
            }
        }
        return vector2;
    }

    @Override
    public DatabaseMapping getMapping() {
        if (!this.hasMapping) {
            return null;
        }
        if (this.mapping == null) {
            this.mapping = super.getMapping();
            if (this.mapping == null) {
                this.hasMapping = false;
            }
        }
        return this.mapping;
    }

    public DatabaseMapping getMappingFromQueryKey() {
        QueryKey queryKey = this.getQueryKeyOrNull();
        if (queryKey == null || !(queryKey instanceof DirectQueryKey)) {
            throw QueryException.cannotConformExpression();
        }
        this.mapping = queryKey.getDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)queryKey).getField());
        if (this.mapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return this.mapping;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Vector getOwnedTables() {
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            Vector<NestedTable> vector = null;
            vector = this.shouldQueryToManyRelationship() ? (Vector<NestedTable>)super.getOwnedTables().clone() : new Vector<NestedTable>(1);
            vector.addElement(new NestedTable(this));
            return vector;
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            return null;
        }
        return super.getOwnedTables();
    }

    @Override
    public QueryKey getQueryKeyOrNull() {
        if (!this.hasQueryKey) {
            return null;
        }
        if (this.getContainingDescriptor() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        if (this.queryKey == null) {
            this.queryKey = this.getContainingDescriptor().getQueryKeyNamed(this.getName());
            if (this.queryKey == null) {
                this.hasQueryKey = false;
            }
        }
        return this.queryKey;
    }

    protected void initializeAliasedField() {
        DatabaseField databaseField = (DatabaseField)this.getField().clone();
        DatabaseTable databaseTable = this.getAliasedTable();
        this.aliasedField = databaseField;
        this.aliasedField.setTable(databaseTable);
    }

    @Override
    public boolean isAttribute() {
        if (this.isAttributeExpression == null) {
            if (this.getSession() == null) {
                return false;
            }
            QueryKey queryKey = this.getQueryKeyOrNull();
            if (queryKey != null) {
                this.isAttributeExpression = queryKey.isDirectQueryKey();
            } else {
                DatabaseMapping databaseMapping = this.getMapping();
                if (databaseMapping != null) {
                    if (databaseMapping.isVariableOneToOneMapping()) {
                        throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(databaseMapping, databaseMapping.getDescriptor());
                    }
                    this.isAttributeExpression = databaseMapping.isDirectToFieldMapping();
                } else {
                    this.isAttributeExpression = Boolean.FALSE;
                }
            }
        }
        return this.isAttributeExpression;
    }

    @Override
    public boolean isQueryKeyExpression() {
        return true;
    }

    @Override
    public Expression mappingCriteria() {
        Expression expression;
        if (this.getQueryKeyOrNull() == null) {
            if (this.getMapping() == null || !this.getMapping().isForeignReferenceMapping()) {
                return null;
            }
            expression = ((ForeignReferenceMapping)this.getMapping()).getJoinCriteria(this);
        } else {
            if (!this.getQueryKeyOrNull().isForeignReferenceQueryKey()) {
                return null;
            }
            expression = ((ForeignReferenceQueryKey)this.getQueryKeyOrNull()).getJoinCriteria();
            expression = this.getBaseExpression().twist(expression, this);
        }
        if (this.shouldUseOuterJoin() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
            expression = expression.convertToUseOuterJoin();
        }
        return expression;
    }

    @Override
    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        return this.normalize(expressionNormalizer, null);
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer, Vector vector) {
        Expression expression;
        if (this.hasBeenNormalized()) {
            return this;
        }
        super.normalize(expressionNormalizer);
        this.setHasBeenNormalized(true);
        if (this.getMapping() != null && this.getMapping().isDirectToXMLTypeMapping()) {
            expressionNormalizer.getStatement().setRequiresAliases(true);
        }
        if (this.isAttribute()) {
            return this;
        }
        if (this.getMapping() != null && (this.getMapping().isReferenceMapping() || this.getMapping().isStructureMapping())) {
            expressionNormalizer.getStatement().setRequiresAliases(true);
            return this;
        }
        if (this.shouldQueryToManyRelationship() && !expressionNormalizer.getStatement().isDistinctComputed() && !expressionNormalizer.getStatement().isAggregateSelect()) {
            expressionNormalizer.getStatement().useDistinct();
        }
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            if (!this.shouldQueryToManyRelationship()) {
                return this;
            }
            expressionNormalizer.getStatement().dontUseDistinct();
        }
        if ((expression = this.mappingCriteria()) != null) {
            expression = expression.normalize(expressionNormalizer);
        }
        if (expression != null) {
            if (this.shouldUseOuterJoin() && this.getSession().getPlatform().isInformixOuterJoin()) {
                expressionNormalizer.getStatement().getOuterJoinExpressions().addElement(this);
                expressionNormalizer.getStatement().getOuterJoinedMappingCriteria().addElement(expression);
                expressionNormalizer.addAdditionalExpression(expression.and(this.additionalExpressionCriteria()));
                return this;
            }
            if ((this.shouldUseOuterJoin() || this.isUsingOuterJoinForMultitableInheritance()) && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                if (this.shouldUseOuterJoin()) {
                    expressionNormalizer.getStatement().getOuterJoinExpressions().addElement(this);
                    expressionNormalizer.getStatement().getOuterJoinedMappingCriteria().addElement(expression);
                    expressionNormalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                    expressionNormalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(null);
                    return this;
                }
                if (this.isUsingOuterJoinForMultitableInheritance()) {
                    expressionNormalizer.getStatement().getOuterJoinExpressions().addElement(null);
                    expressionNormalizer.getStatement().getOuterJoinedMappingCriteria().addElement(null);
                    expressionNormalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                    expressionNormalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(this.getMapping().getReferenceDescriptor());
                }
            }
            if (vector != null) {
                vector.add(expression);
            } else {
                expressionNormalizer.addAdditionalExpression(expression.and(this.additionalExpressionCriteria()));
            }
        }
        return this;
    }

    @Override
    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        Cloneable cloneable;
        if (this.isAttribute()) {
            expressionSQLPrinter.printField(this.getAliasedField());
        }
        if (this.getMapping() != null && this.getMapping().isDirectCollectionMapping()) {
            cloneable = (DirectCollectionMapping)this.getMapping();
            TableExpression tableExpression = (TableExpression)this.getTable(((DirectCollectionMapping)cloneable).getReferenceTable());
            DatabaseTable databaseTable = tableExpression.aliasForTable(tableExpression.getTable());
            DatabaseField databaseField = (DatabaseField)((DirectCollectionMapping)cloneable).getDirectField().clone();
            databaseField.setTable(databaseTable);
            expressionSQLPrinter.printField(databaseField);
        }
        if (this.getMapping() != null && this.getMapping().isNestedTableMapping()) {
            cloneable = this.aliasForTable(new NestedTable(this));
            expressionSQLPrinter.printString(((DatabaseTable)cloneable).getName());
        }
    }

    @Override
    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        this.getBaseExpression().printJava(expressionJavaPrinter);
        if (!this.shouldUseOuterJoin()) {
            if (!this.shouldQueryToManyRelationship()) {
                expressionJavaPrinter.printString(".get(");
            } else {
                expressionJavaPrinter.printString(".anyOf(");
            }
        } else if (!this.shouldQueryToManyRelationship()) {
            expressionJavaPrinter.printString(".getAllowingNull(");
        } else {
            expressionJavaPrinter.printString(".anyOfAllowingNone(");
        }
        expressionJavaPrinter.printString("\"" + this.getName() + "\")");
    }

    @Override
    public Expression rebuildOn(Expression expression) {
        Expression expression2 = this.getBaseExpression().rebuildOn(expression);
        QueryKeyExpression queryKeyExpression = null;
        queryKeyExpression = this.shouldUseOuterJoin ? (QueryKeyExpression)expression2.getAllowingNull(this.getName()) : (QueryKeyExpression)expression2.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            queryKeyExpression.doQueryToManyRelationship();
        }
        queryKeyExpression.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return queryKeyExpression;
    }

    public Expression rebuildOn(Expression expression, Expression expression2) {
        if (this == expression) {
            return expression2;
        }
        Expression expression3 = ((QueryKeyExpression)this.getBaseExpression()).rebuildOn(expression, expression2);
        QueryKeyExpression queryKeyExpression = null;
        queryKeyExpression = this.shouldUseOuterJoin ? (QueryKeyExpression)expression3.getAllowingNull(this.getName()) : (QueryKeyExpression)expression3.get(this.getName());
        if (this.shouldQueryToManyRelationship) {
            queryKeyExpression.doQueryToManyRelationship();
        }
        queryKeyExpression.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return queryKeyExpression;
    }

    @Override
    protected void resetCache() {
        this.hasMapping = true;
        this.mapping = null;
        this.hasQueryKey = true;
        this.queryKey = null;
    }

    public boolean shouldQueryToManyRelationship() {
        return this.shouldQueryToManyRelationship;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        Expression expression3 = this.getBaseExpression().twistedForBaseAndContext(expression, expression2);
        QueryKeyExpression queryKeyExpression = (QueryKeyExpression)expression3.get(this.getName());
        if (this.shouldUseOuterJoin) {
            queryKeyExpression.doUseOuterJoin();
        }
        if (this.shouldQueryToManyRelationship) {
            queryKeyExpression.doQueryToManyRelationship();
        }
        return queryKeyExpression;
    }

    @Override
    public void validateNode() {
        if (this.getQueryKeyOrNull() == null && this.getMapping() == null) {
            throw QueryException.invalidQueryKeyInExpression(this.getName());
        }
        QueryKey queryKey = this.getQueryKeyOrNull();
        DatabaseMapping databaseMapping = this.getMapping();
        Cloneable cloneable = null;
        if (queryKey != null) {
            cloneable = queryKey;
        }
        if (databaseMapping != null) {
            cloneable = databaseMapping;
        }
        boolean bl = false;
        if (queryKey != null) {
            boolean bl2 = bl = queryKey.isManyToManyQueryKey() || queryKey.isOneToManyQueryKey();
        }
        if (databaseMapping != null) {
            if (!(!this.shouldUseOuterJoin || databaseMapping.isOneToOneMapping() || databaseMapping.isOneToManyMapping() || databaseMapping.isManyToManyMapping() || databaseMapping.isAggregateCollectionMapping() || databaseMapping.isDirectCollectionMapping())) {
                throw QueryException.outerJoinIsOnlyValidForOneToOneMappings(this.getMapping());
            }
            bl = databaseMapping.isCollectionMapping();
        }
        if (!this.shouldQueryToManyRelationship() && bl && !databaseMapping.isNestedTableMapping()) {
            throw QueryException.invalidUseOfToManyQueryKeyInExpression(cloneable);
        }
        if (this.shouldQueryToManyRelationship() && !bl) {
            throw QueryException.invalidUseOfAnyOfInExpression(cloneable);
        }
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        if (!this.getBaseExpression().isExpressionBuilder() && this.getBaseExpression().isQueryKeyExpression()) {
            object = this.getBaseExpression().valueFromObject(object, abstractSession, abstractRecord, n, bl);
            if (object == null) {
                return null;
            }
            if (object instanceof Vector) {
                Vector<Object> vector = new Vector<Object>(((Vector)object).size() + 2);
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e == null) {
                        vector.addElement(e);
                        continue;
                    }
                    Object object2 = this.valuesFromCollection(e, abstractSession, n, bl);
                    if (object2 instanceof Vector) {
                        Enumeration enumeration2 = ((Vector)object2).elements();
                        while (enumeration2.hasMoreElements()) {
                            vector.addElement(enumeration2.nextElement());
                        }
                        continue;
                    }
                    vector.addElement(object2);
                }
                return vector;
            }
        }
        return this.valuesFromCollection(object, abstractSession, n, bl);
    }

    public Object valuesFromCollection(Object object, AbstractSession abstractSession, int n, boolean bl) {
        Object object2;
        DatabaseMapping databaseMapping;
        ClassDescriptor classDescriptor;
        boolean bl2 = false;
        if (this.getMapping() == null) {
            this.getMappingFromQueryKey();
            bl2 = true;
        }
        if ((classDescriptor = (databaseMapping = this.mapping).getDescriptor()).hasInheritance() && classDescriptor.getJavaClass() != object.getClass()) {
            databaseMapping = abstractSession.getDescriptor(object.getClass()).getObjectBuilder().getMappingForAttributeName(this.getName());
            classDescriptor = databaseMapping.getDescriptor();
        }
        if (classDescriptor.hasFetchGroupManager() && ((FetchGroupManager)(object2 = classDescriptor.getFetchGroupManager())).isPartialObject(object) && !((FetchGroupManager)object2).isAttributeFetched(object, databaseMapping.getAttributeName())) {
            throw QueryException.cannotConformUnfetchedAttribute(databaseMapping.getAttributeName());
        }
        if (databaseMapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)databaseMapping).valueFromObject(object, databaseMapping.getField(), abstractSession);
        }
        if (databaseMapping.isForeignReferenceMapping()) {
            Object object3;
            UnitOfWorkImpl unitOfWorkImpl;
            object2 = databaseMapping.getAttributeValueFromObject(object);
            if (!((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object2) && n != 1) {
                throw QueryException.mustInstantiateValueholders();
            }
            Object object4 = databaseMapping.getRealAttributeValueFromObject(object, abstractSession);
            UnitOfWorkImpl unitOfWorkImpl2 = unitOfWorkImpl = bl ? (UnitOfWorkImpl)abstractSession : null;
            if (databaseMapping.isCollectionMapping() && object4 != null) {
                object4 = databaseMapping.getContainerPolicy().vectorFor(object4, abstractSession);
                if (bl && unitOfWorkImpl.getCloneMapping().get(object) == null) {
                    Vector vector = (Vector)object4;
                    for (int i = 0; i < vector.size(); ++i) {
                        Object e = vector.elementAt(i);
                        Object object5 = unitOfWorkImpl.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(e);
                        if (object5 == null) continue;
                        vector.setElementAt(object5, i);
                    }
                }
            } else if (bl && unitOfWorkImpl.getCloneMapping().get(object) == null && (object3 = unitOfWorkImpl.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(object4)) != null) {
                object4 = object3;
            }
            return object4;
        }
        if (databaseMapping.isAggregateMapping()) {
            object2 = databaseMapping.getAttributeValueFromObject(object);
            while (bl2 && databaseMapping.isAggregateObjectMapping() && !((AggregateObjectMapping)databaseMapping).getReferenceClass().equals(this.queryKey.getDescriptor().getJavaClass())) {
                databaseMapping = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(((DirectQueryKey)this.queryKey).getField());
                object2 = databaseMapping.getRealAttributeValueFromObject(object2, abstractSession);
            }
            return object2;
        }
        throw QueryException.cannotConformExpression();
    }

    @Override
    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getName());
        bufferedWriter.write(this.tableAliasesDescription());
    }

    public boolean isNormalizationRequired() {
        return this.shouldQueryToManyRelationship() || this.getMapping() == null || (this.shouldUseOuterJoin() || this.isUsingOuterJoinForMultitableInheritance()) && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() || this.shouldUseOuterJoin() && this.getSession().getPlatform().isInformixOuterJoin();
    }
}

