/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;

public class SubSelectExpression
extends BaseExpression {
    protected ReportQuery subQuery;

    public SubSelectExpression() {
    }

    public SubSelectExpression(ReportQuery reportQuery, Expression expression) {
        super(expression);
        this.subQuery = reportQuery;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String descriptionOfNodeType() {
        return "SubSelect";
    }

    public ReportQuery getSubQuery() {
        return this.subQuery;
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        super.iterateOn(expressionIterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(expressionIterator);
        }
        if (expressionIterator.shouldIterateOverSubSelects()) {
            if (this.getSubQuery().getSelectionCriteria() != null) {
                this.getSubQuery().getSelectionCriteria().iterateOn(expressionIterator);
            } else {
                this.getSubQuery().getExpressionBuilder().iterateOn(expressionIterator);
            }
        }
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        this.validateNode();
        expressionNormalizer.addSubSelectExpression(this);
        expressionNormalizer.getStatement().setRequiresAliases(true);
        return this;
    }

    public Expression normalizeSubSelect(ExpressionNormalizer expressionNormalizer, Map map) {
        Cloneable cloneable;
        if (!this.getSubQuery().isCallQuery() && this.getSubQuery().getReferenceClass() == null) {
            Expression expression;
            cloneable = this.getSubQuery();
            Expression expression2 = ((DatabaseQuery)cloneable).getSelectionCriteria();
            if (expression2 instanceof LogicalExpression) {
                expression2 = ((LogicalExpression)expression2).getFirstChild();
            }
            if (expression2 instanceof RelationExpression && (expression = ((RelationExpression)expression2).getSecondChild()) instanceof QueryKeyExpression) {
                ((ObjectLevelReadQuery)cloneable).setReferenceClass(((QueryKeyExpression)expression).getDescriptor().getJavaClass());
            }
        }
        this.validateNode();
        this.getSubQuery().prepareSubSelect(expressionNormalizer.getSession(), null, map);
        if (!this.getSubQuery().isCallQuery()) {
            cloneable = (SQLSelectStatement)((StatementQueryMechanism)this.getSubQuery().getQueryMechanism()).getSQLStatement();
            ((SQLSelectStatement)cloneable).setRequiresAliases(true);
            ((SQLSelectStatement)cloneable).setParentStatement(expressionNormalizer.getStatement());
            ((SQLSelectStatement)cloneable).normalize(expressionNormalizer.getSession(), this.getSubQuery().getDescriptor(), map);
        }
        return this;
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        ReportQuery reportQuery = (ReportQuery)this.getSubQuery().clone();
        if (!reportQuery.isCallQuery()) {
            if (reportQuery.getSelectionCriteria() != null) {
                reportQuery.setSelectionCriteria(this.getSubQuery().getSelectionCriteria().copiedVersionFrom(map));
                if (reportQuery.getExpressionBuilder() != null) {
                    reportQuery.setExpressionBuilder(reportQuery.getSelectionCriteria().getBuilder());
                }
            } else if (reportQuery.getExpressionBuilder() != null) {
                reportQuery.setExpressionBuilder((ExpressionBuilder)reportQuery.getExpressionBuilder().copiedVersionFrom(map));
            }
            if (map.get(map) != null) {
                reportQuery.copyReportItems(map);
            }
        }
        this.setSubQuery(reportQuery);
    }

    protected void printCustomSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        SQLCall sQLCall = (SQLCall)this.getSubQuery().getCall();
        sQLCall.translateCustomQuery();
        expressionSQLPrinter.getCall().getParameters().addAll(sQLCall.getParameters());
        expressionSQLPrinter.getCall().getParameterTypes().addAll(sQLCall.getParameterTypes());
        expressionSQLPrinter.printString(sQLCall.getCallString());
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        ReportQuery reportQuery = this.getSubQuery();
        expressionSQLPrinter.printString("(");
        if (reportQuery.isCallQuery()) {
            this.printCustomSQL(expressionSQLPrinter);
        } else {
            SQLSelectStatement sQLSelectStatement = (SQLSelectStatement)((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).getSQLStatement();
            boolean bl = expressionSQLPrinter.isFirstElementPrinted();
            expressionSQLPrinter.setIsFirstElementPrinted(false);
            boolean bl2 = expressionSQLPrinter.requiresDistinct();
            sQLSelectStatement.printSQL(expressionSQLPrinter);
            expressionSQLPrinter.setIsFirstElementPrinted(bl);
            expressionSQLPrinter.setRequiresDistinct(bl2);
        }
        expressionSQLPrinter.printString(")");
    }

    public Expression rebuildOn(Expression expression) {
        return this;
    }

    public void setSubQuery(ReportQuery reportQuery) {
        this.subQuery = reportQuery;
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(String.valueOf(this.getSubQuery()));
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.getSubQuery().getSelectionCriteria() != null) {
            this.getSubQuery().getSelectionCriteria().toString(bufferedWriter, n);
        }
    }
}

