/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentFixedCache
implements Serializable {
    protected int maxSize;
    protected Map cache;

    public ConcurrentFixedCache() {
        this(100);
    }

    public ConcurrentFixedCache(int n) {
        this.cache = new ConcurrentHashMap(n);
        this.maxSize = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public Object get(Object object) {
        return this.cache.get(object);
    }

    public void put(Object object, Object object2) {
        if (this.maxSize == 0) {
            return;
        }
        this.cache.put(object, object2);
        if (this.cache.size() > this.maxSize) {
            Iterator iterator = this.cache.keySet().iterator();
            try {
                while (this.cache.size() > this.maxSize && iterator.hasNext()) {
                    Object k = iterator.next();
                    if (k == object) continue;
                    this.cache.remove(k);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map getCache() {
        return this.cache;
    }
}

