/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class LOBValueWriter {
    private Collection calls = null;
    private Accessor accessor;

    public LOBValueWriter(Accessor accessor) {
        this.accessor = accessor;
    }

    protected void buildAndExecuteCall(DatabaseCall databaseCall, AbstractSession abstractSession) {
        DatabaseQuery databaseQuery = databaseCall.getQuery();
        if (!databaseQuery.isWriteObjectQuery()) {
            return;
        }
        WriteObjectQuery writeObjectQuery = (WriteObjectQuery)databaseQuery;
        writeObjectQuery.setAccessor(this.accessor);
        SQLSelectStatement sQLSelectStatement = this.buildSelectStatementForLocator(writeObjectQuery, databaseCall, abstractSession);
        DatabaseCall databaseCall2 = this.buildCallFromSelectStatementForLocator(sQLSelectStatement, writeObjectQuery, databaseCall, abstractSession);
        this.accessor.executeCall(databaseCall2, databaseCall2.getQuery().getTranslationRow(), abstractSession);
    }

    public void fetchLocatorAndWriteValue(DatabaseCall databaseCall, Object object) throws SQLException {
        Enumeration enumeration = databaseCall.getContexts().getFields().elements();
        Enumeration enumeration2 = databaseCall.getContexts().getValues().elements();
        AbstractSession abstractSession = databaseCall.getQuery().getSession().getExecutionSession(databaseCall.getQuery());
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object e = enumeration2.nextElement();
            abstractSession.getPlatform().writeLOB(databaseField, e, (ResultSet)object, abstractSession);
        }
    }

    private SQLSelectStatement buildSelectStatementForLocator(WriteObjectQuery writeObjectQuery, DatabaseCall databaseCall, AbstractSession abstractSession) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        Vector<DatabaseTable> vector = writeObjectQuery.getDescriptor().getTables();
        sQLSelectStatement.setTables(vector);
        sQLSelectStatement.setFields(databaseCall.getContexts().getFields());
        sQLSelectStatement.setWhereClause(writeObjectQuery.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(writeObjectQuery.getObject(), abstractSession));
        sQLSelectStatement.setLockingClause(ForUpdateClause.newInstance((short)1));
        if (vector.size() > 1) {
            Expression expression = sQLSelectStatement.getWhereClause();
            Expression expression2 = writeObjectQuery.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            if (expression2 != null) {
                expression = expression.and(expression2);
            }
            sQLSelectStatement.setWhereClause(expression);
        }
        sQLSelectStatement.normalize(abstractSession, writeObjectQuery.getDescriptor());
        return sQLSelectStatement;
    }

    private DatabaseCall buildCallFromSelectStatementForLocator(SQLSelectStatement sQLSelectStatement, WriteObjectQuery writeObjectQuery, DatabaseCall databaseCall, AbstractSession abstractSession) {
        DatabaseCall databaseCall2 = sQLSelectStatement.buildCall(abstractSession);
        databaseCall2.setIsNativeConnectionRequired(true);
        databaseCall2.setContexts(databaseCall.getContexts());
        databaseCall2.returnOneRow();
        databaseCall2.setQuery(writeObjectQuery);
        databaseCall2.prepare(abstractSession);
        databaseCall2.translate(writeObjectQuery.getTranslationRow(), writeObjectQuery.getModifyRow(), abstractSession);
        return databaseCall2;
    }

    public void addCall(Call call) {
        if (this.calls == null) {
            this.calls = new ArrayList(2);
        }
        this.calls.add(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAndExecuteSelectCalls(AbstractSession abstractSession) {
        if (this.calls == null || this.calls.isEmpty()) {
            return;
        }
        try {
            for (DatabaseCall databaseCall : this.calls) {
                this.buildAndExecuteCall(databaseCall, abstractSession);
            }
        }
        finally {
            this.calls.clear();
        }
    }
}

