/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkCacheKey;

public class UnitOfWorkIdentityMap
extends FullIdentityMap {
    public UnitOfWorkIdentityMap(int n, ClassDescriptor classDescriptor) {
        this.maxSize = n;
        this.cacheKeys = new HashMap(n);
        this.descriptor = classDescriptor;
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2, long l) {
        return new UnitOfWorkCacheKey(vector, object, object2, l);
    }

    public CacheKey acquireDeferredLock(Vector vector) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        return cacheKey2;
    }

    public CacheKey acquireLock(Vector vector, boolean bl) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        return cacheKey2;
    }

    public CacheKey acquireLockNoWait(Vector vector, boolean bl) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        return cacheKey2;
    }

    public CacheKey acquireLockWithWait(Vector vector, boolean bl, int n) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        return cacheKey2;
    }

    public CacheKey acquireReadLockOnCacheKey(Vector vector) {
        return this.acquireReadLockOnCacheKeyNoWait(vector);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        CacheKey cacheKey2 = this.getCacheKey(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        return cacheKey2;
    }

    protected CacheKey getCacheKeyWithReadLock(Vector vector) {
        return this.getCacheKey(vector);
    }

    protected CacheKey getCacheKeyIfAbsentPut(CacheKey cacheKey) {
        CacheKey cacheKey2 = this.getCacheKeys().get(cacheKey);
        if (cacheKey2 == null) {
            cacheKey.setOwningMap(this);
            this.getCacheKeys().put(cacheKey, cacheKey);
            return null;
        }
        return cacheKey2;
    }

    public Object remove(CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        this.getCacheKeys().remove(cacheKey);
        return cacheKey.getObject();
    }

    public void resetCacheKey(CacheKey cacheKey, Object object, Object object2, long l) {
        cacheKey.setObject(object);
        cacheKey.setWriteLockValue(object2);
        cacheKey.setReadTime(l);
    }

    public void setWriteLockValue(Vector vector, Object object) {
        CacheKey cacheKey = this.getCacheKeyForLock(vector);
        if (cacheKey != null) {
            cacheKey.setWriteLockValue(object);
        }
    }
}

