/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;

public class TransformerBasedValueHolder
extends DatabaseValueHolder {
    protected transient AttributeTransformer transformer;
    protected transient Object object;

    public TransformerBasedValueHolder(AttributeTransformer attributeTransformer, Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.row = abstractRecord;
        this.session = abstractSession;
        if (!this.session.isUnitOfWork()) {
            this.session = this.session.getRootSession(null);
        }
        this.transformer = attributeTransformer;
        this.object = object;
    }

    protected AttributeTransformer getTransformer() {
        return this.transformer;
    }

    protected Object getObject() {
        return this.object;
    }

    protected Object instantiate() throws DescriptorException {
        return this.instantiate(this.getObject(), this.getSession());
    }

    protected Object instantiate(Object object, AbstractSession abstractSession) throws DescriptorException {
        try {
            return this.transformer.buildAttributeValue(this.getRow(), object, abstractSession);
        }
        catch (DescriptorException descriptorException) {
            Throwable throwable = descriptorException.getInternalException();
            if (throwable instanceof IllegalAccessException) {
                throw DescriptorException.illegalAccessWhileInstantiatingMethodBasedProxy(throwable);
            }
            if (throwable instanceof IllegalArgumentException) {
                throw DescriptorException.illegalArgumentWhileInstantiatingMethodBasedProxy(throwable);
            }
            if (throwable instanceof InvocationTargetException) {
                throw DescriptorException.targetInvocationWhileInstantiatingMethodBasedProxy(throwable);
            }
            throw descriptorException;
        }
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(this.getObject(), unitOfWorkValueHolder.getUnitOfWork());
    }

    public boolean isPessimisticLockingValueHolder() {
        return false;
    }

    protected void setTransformer(AttributeTransformer attributeTransformer) {
        this.transformer = attributeTransformer;
    }

    protected void setObject(Object object) {
        this.object = object;
    }
}

