/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class WeavedObjectBasicIndirectionPolicy
extends BasicIndirectionPolicy {
    protected String setMethodName = null;
    protected Method setMethod = null;

    public WeavedObjectBasicIndirectionPolicy(String string) {
        this.setMethodName = string;
    }

    public Object getRealAttributeValueFromObject(Object object, Object object2) {
        Object object3 = super.getRealAttributeValueFromObject(object, object2);
        this.updateValueInObject(object, object3, object2);
        return object3;
    }

    protected Method getSetMethod() {
        if (this.setMethod == null) {
            ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)this.mapping;
            Class[] classArray = new Class[]{foreignReferenceMapping.getReferenceClass()};
            try {
                this.setMethod = Helper.getDeclaredMethod(foreignReferenceMapping.getDescriptor().getJavaClass(), this.setMethodName, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw DescriptorException.errorAccessingSetMethodOfEntity(foreignReferenceMapping.getDescriptor().getJavaClass(), this.setMethodName, foreignReferenceMapping.getDescriptor(), noSuchMethodException);
            }
        }
        return this.setMethod;
    }

    public void updateValueInObject(Object object, Object object2, Object object3) {
        this.setRealAttributeValueInObject(object, object2);
        ((WeavedAttributeValueHolderInterface)object3).setIsCoordinatedWithProperty(true);
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        PropertyChangeListener propertyChangeListener = null;
        ChangeTracker changeTracker = null;
        if (object instanceof ChangeTracker) {
            changeTracker = (ChangeTracker)object;
            propertyChangeListener = changeTracker._persistence_getPropertyChangeListener();
            changeTracker._persistence_setPropertyChangeListener(null);
        }
        Object[] objectArray = new Object[]{object2};
        try {
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), object, objectArray));
                            break block13;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            if (exception instanceof IllegalAccessException) {
                                throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.setMethod.getName(), object2, exception);
                            }
                            throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.setMethod.getName(), object2, exception);
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), object, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.setMethod.getName(), object2, illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.setMethod.getName(), object2, illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.setMethod.getName(), object2, invocationTargetException);
                }
            }
            Object var9_11 = null;
            if (changeTracker != null) {
                changeTracker._persistence_setPropertyChangeListener(propertyChangeListener);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (changeTracker != null) {
                changeTracker._persistence_setPropertyChangeListener(propertyChangeListener);
            }
            throw throwable;
        }
    }
}

