/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;

public abstract class AggregateNode
extends Node {
    private boolean distinct = false;

    public String resolveAttribute() {
        Node node = this.getLeft();
        return node.isDotNode() ? ((DotNode)node).resolveAttribute() : null;
    }

    public Class resolveClass(GenerationContext generationContext) {
        return this.getLeft().resolveClass(generationContext);
    }

    public boolean isAggregateNode() {
        return true;
    }

    public boolean usesDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public Expression generateExpression(GenerationContext generationContext) {
        String string = this.getAsString();
        Expression expression = generationContext.expressionFor(string);
        if (expression == null) {
            Expression expression2 = this.getLeft().generateExpression(generationContext);
            if (this.usesDistinct()) {
                expression2 = expression2.distinct();
            }
            expression = this.addAggregateExression(expression2);
            generationContext.addExpression(expression, string);
        }
        return expression;
    }

    protected abstract Expression addAggregateExression(Expression var1);
}

