/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.deferred.DescriptorNotFoundContentHandler;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class XMLRelationshipMappingNodeValue
extends MappingNodeValue {
    public void processChild(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes attributes, XMLDescriptor xMLDescriptor, DatabaseMapping databaseMapping) throws SAXException {
        Serializable serializable;
        if (xMLDescriptor == null) {
            DescriptorNotFoundContentHandler descriptorNotFoundContentHandler = new DescriptorNotFoundContentHandler(unmarshalRecord, databaseMapping);
            String string = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                string = xPathFragment.getPrefix() + ":" + string;
            }
            descriptorNotFoundContentHandler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), string, attributes);
            unmarshalRecord.getXMLReader().setContentHandler(descriptorNotFoundContentHandler);
            return;
        }
        if (xMLDescriptor.hasInheritance()) {
            QName qName;
            unmarshalRecord.setAttributes(attributes);
            serializable = xMLDescriptor.getInheritancePolicy().classFromRow(unmarshalRecord, unmarshalRecord.getSession());
            if (serializable == null && (qName = unmarshalRecord.getLeafElementType()) != null) {
                Object v = xMLDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(qName);
                if (v == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(qName, xMLDescriptor.getInheritancePolicy().getDescriptor());
                }
                serializable = (Class)v;
            }
            if (serializable != null) {
                xMLDescriptor = (XMLDescriptor)unmarshalRecord.getSession().getDescriptor((Class)serializable);
            } else if (Modifier.isAbstract(xMLDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(unmarshalRecord, xMLDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        serializable = (TreeObjectBuilder)xMLDescriptor.getObjectBuilder();
        unmarshalRecord.setChildRecord((UnmarshalRecord)serializable.createRecord(unmarshalRecord.getSession()));
        unmarshalRecord.getChildRecord().setAttributes(attributes);
        unmarshalRecord.getChildRecord().setUnmarshaller(unmarshalRecord.getUnmarshaller());
        unmarshalRecord.getChildRecord().startDocument();
        unmarshalRecord.getChildRecord().startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), xPathFragment.getShortName(), attributes);
        unmarshalRecord.getXMLReader().setContentHandler(unmarshalRecord.getChildRecord());
        try {
            unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord.getChildRecord());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        unmarshalRecord.getChildRecord().setXMLReader(unmarshalRecord.getXMLReader());
    }

    protected XMLDescriptor findReferenceDescriptor(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes attributes, DatabaseMapping databaseMapping, UnmarshalKeepAsElementPolicy unmarshalKeepAsElementPolicy) {
        XMLDescriptor xMLDescriptor = null;
        XMLContext xMLContext = unmarshalRecord.getUnmarshaller().getXMLContext();
        String string = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (string != null && !string.equals("")) {
            Object object;
            XPathFragment xPathFragment2 = new XPathFragment();
            xPathFragment2.setXPath(string);
            QName qName = null;
            if (xPathFragment2.hasNamespace()) {
                object = xPathFragment2.getPrefix();
                String string2 = unmarshalRecord.resolveNamespacePrefix((String)object);
                xPathFragment2.setNamespaceURI(string2);
                qName = new QName(string2, xPathFragment2.getLocalName());
                unmarshalRecord.setTypeQName(qName);
            }
            if ((xMLDescriptor = xMLContext.getDescriptorByGlobalType(xPathFragment2)) == null && (unmarshalKeepAsElementPolicy == null || unmarshalKeepAsElementPolicy != null && unmarshalKeepAsElementPolicy != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && unmarshalKeepAsElementPolicy != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT)) {
                XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                object = (Class)XMLConversionManager.getDefaultXMLTypes().get(qName);
                if (object == null) {
                    throw XMLMarshalException.noDescriptorFound(databaseMapping);
                }
            }
        }
        return xMLDescriptor;
    }

    protected void addTypeAttribute(XMLDescriptor xMLDescriptor, MarshalRecord marshalRecord, String string) {
        String string2 = string.substring(1);
        String string3 = null;
        if (xMLDescriptor.getNamespaceResolver() != null) {
            string3 = xMLDescriptor.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            string3 = "xsi";
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string3, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (string3 == null) {
            string3 = xMLDescriptor.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string3, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", string3 + ":" + "type", string2);
    }

    protected void writeExtraNamespaces(List list, XMLRecord xMLRecord, AbstractSession abstractSession) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            ((MarshalRecord)xMLRecord).attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    protected void setupHandlerForKeepAsElementPolicy(UnmarshalRecord unmarshalRecord, XPathFragment xPathFragment, Attributes attributes) {
        SAXFragmentBuilder sAXFragmentBuilder = unmarshalRecord.getFragmentBuilder();
        sAXFragmentBuilder.setOwningRecord(unmarshalRecord);
        try {
            String string = "";
            if (xPathFragment.getNamespaceURI() != null) {
                string = xPathFragment.getNamespaceURI();
            }
            String string2 = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                string2 = xPathFragment.getPrefix() + ":" + string2;
            }
            sAXFragmentBuilder.startElement(string, xPathFragment.getLocalName(), string2, attributes);
            unmarshalRecord.getXMLReader().setContentHandler(sAXFragmentBuilder);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void setOrAddAttributeValueForKeepAsElement(SAXFragmentBuilder sAXFragmentBuilder, XMLMapping xMLMapping, XMLConverter xMLConverter, UnmarshalRecord unmarshalRecord, boolean bl, Object object) {
        Object object2 = sAXFragmentBuilder.getNodes().pop();
        if (xMLConverter != null) {
            object2 = xMLConverter.convertDataValueToObjectValue(object2, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
        }
        if (bl) {
            if (object != null) {
                unmarshalRecord.addAttributeValue((ContainerValue)((Object)this), object2, object);
            } else {
                unmarshalRecord.addAttributeValue((ContainerValue)((Object)this), object2);
            }
        } else {
            unmarshalRecord.setAttributeValue(object2, (DatabaseMapping)((Object)xMLMapping));
        }
    }

    protected void endElementProcessText(UnmarshalRecord unmarshalRecord, Converter converter, XPathFragment xPathFragment, Object object) {
        Object object2 = unmarshalRecord.getStringBuffer().toString().trim();
        if (converter != null) {
            object2 = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(object2, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertDataValueToObjectValue(object2, unmarshalRecord.getSession());
        }
        unmarshalRecord.resetStringBuffer();
        if (!"".equals(object2)) {
            Class clazz;
            QName qName = unmarshalRecord.getTypeQName();
            if (qName != null && (clazz = (Class)XMLConversionManager.getDefaultXMLTypes().get(qName)) != null) {
                object2 = ((XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager()).convertObject(object2, clazz, qName);
            }
            this.setOrAddAttributeValue(unmarshalRecord, object2, xPathFragment, object);
        }
    }

    protected abstract void setOrAddAttributeValue(UnmarshalRecord var1, Object var2, XPathFragment var3, Object var4);
}

