/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.documentpreservation;

import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.WeakObjectWrapper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.documentpreservation.AppendNewElementsOrderingPolicy;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescriptorLevelDocumentPreservationPolicy
extends DocumentPreservationPolicy {
    private XMLContext context;

    public DescriptorLevelDocumentPreservationPolicy() {
        this.setNodeOrderingPolicy(new AppendNewElementsOrderingPolicy());
    }

    public void initialize(XMLContext xMLContext) {
        this.context = xMLContext;
    }

    public void addObjectToCache(Object object, Node node) {
        this.addObjectToCache(object, node, null);
    }

    public void addObjectToCache(Object object, Node node, XMLMapping xMLMapping) {
        if (node.getNodeType() != 1) {
            return;
        }
        AbstractSession abstractSession = this.context.getSession(object);
        XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(object);
        DOMRecord dOMRecord = new DOMRecord((Element)node);
        dOMRecord.setSession(abstractSession);
        Vector<WeakObjectWrapper> vector = xMLDescriptor.getObjectBuilder().extractPrimaryKeyFromRow(dOMRecord, abstractSession);
        if (xMLDescriptor.shouldPreserveDocument() || xMLDescriptor.getPrimaryKeyFieldNames().size() > 0) {
            if (vector == null || vector.size() == 0) {
                vector = new Vector<WeakObjectWrapper>();
                vector.addElement(new WeakObjectWrapper(object));
            }
            CacheKey cacheKey = abstractSession.getIdentityMapAccessorInstance().acquireDeferredLock(vector, xMLDescriptor.getJavaClass(), xMLDescriptor);
            if (xMLDescriptor.shouldPreserveDocument()) {
                cacheKey.setRecord(dOMRecord);
            }
            cacheKey.setObject(object);
            cacheKey.releaseDeferredLock();
        }
    }

    public Node getNodeForObject(Object object) {
        AbstractSession abstractSession = this.context.getSession(object);
        XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(object);
        if (xMLDescriptor.shouldPreserveDocument()) {
            CacheKey cacheKey;
            Vector<WeakObjectWrapper> vector = xMLDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession);
            if (vector == null || vector.size() == 0) {
                vector = new Vector<WeakObjectWrapper>();
                vector.addElement(new WeakObjectWrapper(object));
            }
            if ((cacheKey = abstractSession.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, xMLDescriptor.getJavaClass(), xMLDescriptor)) != null && cacheKey.getRecord() != null) {
                return ((DOMRecord)cacheKey.getRecord()).getDOM();
            }
        }
        return null;
    }

    public Object getObjectForNode(Node node) {
        return this.getObjectForNode(node, null);
    }

    public Object getObjectForNode(Node node, XMLMapping xMLMapping) {
        return null;
    }

    public boolean shouldPreserveDocument() {
        return true;
    }
}

