/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.List;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.sequenced.Setting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencedMarshalContext
implements MarshalContext {
    private List<Setting> settings;
    private XPathFragment indexFragment = new XPathFragment();
    private Object value;

    public SequencedMarshalContext(List<Setting> list) {
        this.settings = list;
    }

    public SequencedMarshalContext(Object object) {
        this.value = object;
    }

    @Override
    public MarshalContext getMarshalContext(int n) {
        Setting setting = this.settings.get(n);
        List<Setting> list = setting.getChildren();
        if (null == list) {
            return new SequencedMarshalContext(setting.getValue());
        }
        return new SequencedMarshalContext(list);
    }

    @Override
    public int getNonAttributeChildrenSize(XPathNode xPathNode) {
        if (null == this.settings) {
            return 0;
        }
        return this.settings.size();
    }

    @Override
    public Object getNonAttributeChild(int n, XPathNode xPathNode) {
        Setting setting = this.settings.get(n);
        if (null == setting.getName()) {
            return xPathNode.getNonAttributeChildrenMap().get(null);
        }
        this.indexFragment.setLocalName(null);
        this.indexFragment.setXPath(setting.getName());
        this.indexFragment.setNamespaceURI(setting.getNamespaceURI());
        return xPathNode.getNonAttributeChildrenMap().get(this.indexFragment);
    }

    @Override
    public Object getAttributeValue(Object object, DatabaseMapping databaseMapping) {
        return this.value;
    }

    @Override
    public boolean marshal(NodeValue nodeValue, XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession abstractSession, NamespaceResolver namespaceResolver) {
        if (nodeValue.isContainerValue()) {
            ((ContainerValue)((Object)nodeValue)).marshalSingleValue(xPathFragment, marshalRecord, object, this.value, abstractSession, namespaceResolver, this);
            return true;
        }
        return nodeValue.marshal(xPathFragment, marshalRecord, object, abstractSession, namespaceResolver, this);
    }
}

