/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.SequencingConnectionHandler;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.Login;

class DatabaseSessionConnectionHandler
implements SequencingConnectionHandler {
    DatabaseSessionImpl ownerSession;
    Login login;
    Accessor accessor;
    boolean isBusy;

    DatabaseSessionConnectionHandler(DatabaseSessionImpl databaseSessionImpl, Login login) {
        this.ownerSession = databaseSessionImpl;
        this.login = login;
        this.accessor = login.buildAccessor();
    }

    public void onConnect() {
        if (!this.isConnected()) {
            this.accessor.connect(this.login, this.ownerSession);
        }
    }

    public boolean isConnected() {
        return this.accessor.isConnected();
    }

    public synchronized Accessor acquireAccessor() {
        if (this.isBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitFailureOnSequencingForDatabaseSession(interruptedException);
            }
        }
        this.isBusy = true;
        return this.accessor;
    }

    public synchronized void releaseAccessor(Accessor accessor) {
        this.isBusy = false;
        this.notify();
    }

    public void onDisconnect() {
        if (this.isConnected()) {
            this.accessor.disconnect(this.ownerSession);
        }
    }

    protected void finalize() throws Throwable {
        this.onDisconnect();
    }
}

