/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.OrderedChangeObject;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class CollectionChangeRecord
extends DeferrableChangeRecord
implements org.eclipse.persistence.sessions.changesets.CollectionChangeRecord {
    protected Map addObjectList;
    protected transient Vector orderedAddObjects;
    protected Map orderedAddObjectIndices;
    protected Vector orderedChangeObjectList;
    protected Hashtable orderedRemoveObjects;
    protected transient Vector orderedRemoveObjectIndices;
    protected transient List addOverFlow;
    protected Map removeObjectList;

    public CollectionChangeRecord() {
    }

    public CollectionChangeRecord(ObjectChangeSet objectChangeSet) {
        this.owner = objectChangeSet;
    }

    public void addAdditionChange(Map map, ContainerPolicy containerPolicy, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object object = containerPolicy.unwrapElement(iterator.next());
            ObjectChangeSet objectChangeSet = abstractSession.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, unitOfWorkChangeSet, abstractSession);
            if (objectChangeSet.hasKeys()) {
                this.getAddObjectList().put(objectChangeSet, objectChangeSet);
                continue;
            }
            if (this.getRemoveObjectList().containsKey(objectChangeSet)) {
                this.getRemoveObjectList().remove(objectChangeSet);
                continue;
            }
            this.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void addOrderedAdditionChange(Vector vector, Map map, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ObjectChangeSet objectChangeSet = abstractSession.getDescriptor(e.getClass()).getObjectBuilder().createObjectChangeSet(e, unitOfWorkChangeSet, abstractSession);
            this.getOrderedAddObjects().add(objectChangeSet);
            this.getOrderedAddObjectIndices().put(objectChangeSet, map.get(e));
        }
    }

    public void addOrderedRemoveChange(Vector vector, Hashtable hashtable, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        this.orderedRemoveObjectIndices = vector;
        Enumeration enumeration = this.orderedRemoveObjectIndices.elements();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            Object v = hashtable.get(n);
            ObjectChangeSet objectChangeSet = abstractSession.getDescriptor(v.getClass()).getObjectBuilder().createObjectChangeSet(v, unitOfWorkChangeSet, abstractSession);
            this.getOrderedRemoveObjects().put(n, objectChangeSet);
        }
    }

    public void addRemoveChange(Map map, ContainerPolicy containerPolicy, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        Iterator iterator = containerPolicy.getChangeValuesFrom(map);
        while (iterator.hasNext()) {
            Object object = containerPolicy.unwrapElement(iterator.next());
            ClassDescriptor classDescriptor = this.mapping.getReferenceDescriptor();
            ObjectChangeSet objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(object, unitOfWorkChangeSet, abstractSession);
            if (objectChangeSet.hasKeys()) {
                this.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
                continue;
            }
            if (this.getAddObjectList().containsKey(objectChangeSet)) {
                this.getAddObjectList().remove(objectChangeSet);
                continue;
            }
            this.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public Map getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new IdentityHashMap(10);
        }
        return this.addObjectList;
    }

    public List getAddOverFlow() {
        if (this.addOverFlow == null) {
            this.addOverFlow = new ArrayList();
        }
        return this.addOverFlow;
    }

    public Map getRemoveObjectList() {
        if (this.removeObjectList == null) {
            this.removeObjectList = new IdentityHashMap(10);
        }
        return this.removeObjectList;
    }

    public boolean hasChanges() {
        return this.addObjectList != null && !this.addObjectList.isEmpty() || this.removeObjectList != null && !this.removeObjectList.isEmpty() || this.orderedAddObjects != null && !this.orderedAddObjects.isEmpty() || this.orderedRemoveObjects != null && !this.orderedRemoveObjects.isEmpty() || this.orderedChangeObjectList != null && !this.orderedChangeObjectList.isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord changeRecord, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        for (Object object : ((CollectionChangeRecord)changeRecord).getAddObjectList().keySet()) {
            Object object2 = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)object, unitOfWorkChangeSet2);
            if (this.getRemoveObjectList().containsKey(object2)) {
                this.getRemoveObjectList().remove(object2);
                continue;
            }
            this.getAddObjectList().put(object2, object2);
        }
        for (Object object2 : ((CollectionChangeRecord)changeRecord).getRemoveObjectList().keySet()) {
            Serializable serializable = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)object2, unitOfWorkChangeSet2);
            if (this.getAddObjectList().containsKey(serializable)) {
                this.getAddObjectList().remove(serializable);
                continue;
            }
            this.getRemoveObjectList().put(serializable, serializable);
        }
        for (Serializable serializable : ((CollectionChangeRecord)changeRecord).getOrderedChangeObjectList()) {
            ObjectChangeSet objectChangeSet = ((OrderedChangeObject)serializable).getChangeSet();
            ObjectChangeSet objectChangeSet2 = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet(objectChangeSet, unitOfWorkChangeSet2);
            OrderedChangeObject orderedChangeObject = new OrderedChangeObject(((OrderedChangeObject)serializable).getChangeType(), ((OrderedChangeObject)serializable).getIndex(), objectChangeSet2);
            this.getOrderedChangeObjectList().add(orderedChangeObject);
        }
    }

    public void prepareForSynchronization(AbstractSession abstractSession) {
        Iterator<Object> iterator = this.getAddObjectList().values().iterator();
        while (iterator.hasNext()) {
            this.prepareForSynchronization((ObjectChangeSet)iterator.next(), abstractSession);
        }
        iterator = this.getRemoveObjectList().values().iterator();
        while (iterator.hasNext()) {
            this.prepareForSynchronization((ObjectChangeSet)iterator.next(), abstractSession);
        }
        iterator = this.getOrderedAddObjects().iterator();
        while (iterator.hasNext()) {
            this.prepareForSynchronization((ObjectChangeSet)iterator.next(), abstractSession);
        }
        iterator = this.getOrderedRemoveObjects().values().iterator();
        while (iterator.hasNext()) {
            this.prepareForSynchronization((ObjectChangeSet)iterator.next(), abstractSession);
        }
        for (OrderedChangeObject orderedChangeObject : this.getOrderedChangeObjectList()) {
            this.prepareForSynchronization(orderedChangeObject.getChangeSet(), abstractSession);
        }
    }

    private void prepareForSynchronization(ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        if (objectChangeSet.getSynchronizationType() == 0) {
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(objectChangeSet.getClassType(abstractSession));
            int n = classDescriptor.getCacheSynchronizationType();
            objectChangeSet.setSynchronizationType(n);
            objectChangeSet.prepareChangeRecordsForSynchronization(abstractSession);
        }
    }

    public void setAddObjectList(Map map) {
        this.addObjectList = map;
    }

    public void setRemoveObjectList(Map map) {
        this.removeObjectList = map;
    }

    public void updateReferences(UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> identityHashMap = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getAddObjectList().size() + 1);
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> identityHashMap2 = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getRemoveObjectList().size() + 1);
        if (this.getOrderedAddObjects().size() > 0 || this.getOrderedRemoveObjectIndices().size() > 0) {
            ObjectChangeSet objectChangeSet;
            Object object;
            Vector<ObjectChangeSet> vector = new Vector<ObjectChangeSet>(this.getOrderedAddObjects().size());
            IdentityHashMap identityHashMap3 = new IdentityHashMap(this.getOrderedAddObjectIndices().size());
            for (int i = 0; i < this.getOrderedAddObjects().size(); ++i) {
                object = (ObjectChangeSet)this.getOrderedAddObjects().elementAt(i);
                objectChangeSet = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)object, unitOfWorkChangeSet2);
                vector.add(objectChangeSet);
                identityHashMap3.put(objectChangeSet, this.getOrderedAddObjectIndices().get(object));
                if (!this.getAddObjectList().containsKey(object)) continue;
                identityHashMap.put(objectChangeSet, objectChangeSet);
            }
            this.setOrderedAddObjects(vector);
            this.setOrderedAddObjectIndices(identityHashMap3);
            Hashtable<ObjectChangeSet, ObjectChangeSet> hashtable = new Hashtable<ObjectChangeSet, ObjectChangeSet>(this.getOrderedRemoveObjects().size());
            object = this.getOrderedRemoveObjects().keys();
            while (object.hasMoreElements()) {
                objectChangeSet = object.nextElement();
                ObjectChangeSet objectChangeSet2 = (ObjectChangeSet)this.getOrderedRemoveObjects().get(objectChangeSet);
                ObjectChangeSet objectChangeSet3 = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet(objectChangeSet2, unitOfWorkChangeSet2);
                hashtable.put(objectChangeSet, objectChangeSet3);
                if (!this.getRemoveObjectList().containsKey(objectChangeSet2)) continue;
                identityHashMap2.put(objectChangeSet3, objectChangeSet3);
            }
            this.setOrderedRemoveObjects(hashtable);
        } else {
            ObjectChangeSet objectChangeSet;
            Iterator iterator = this.getAddObjectList().values().iterator();
            while (iterator.hasNext()) {
                objectChangeSet = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)iterator.next(), unitOfWorkChangeSet2);
                identityHashMap.put(objectChangeSet, objectChangeSet);
            }
            iterator = this.getRemoveObjectList().values().iterator();
            while (iterator.hasNext()) {
                objectChangeSet = unitOfWorkChangeSet.findOrIntegrateObjectChangeSet((ObjectChangeSet)iterator.next(), unitOfWorkChangeSet2);
                identityHashMap2.put(objectChangeSet, objectChangeSet);
            }
        }
        this.setAddObjectList(identityHashMap);
        this.setRemoveObjectList(identityHashMap2);
    }

    public Vector getOrderedAddObjects() {
        if (this.orderedAddObjects == null) {
            this.orderedAddObjects = new Vector();
        }
        return this.orderedAddObjects;
    }

    public Integer getOrderedAddObjectIndex(ObjectChangeSet objectChangeSet) {
        return (Integer)this.getOrderedAddObjectIndices().get(objectChangeSet);
    }

    public Map getOrderedAddObjectIndices() {
        if (this.orderedAddObjectIndices == null) {
            this.orderedAddObjectIndices = new IdentityHashMap();
        }
        return this.orderedAddObjectIndices;
    }

    public Vector getOrderedChangeObjectList() {
        if (this.orderedChangeObjectList == null) {
            this.orderedChangeObjectList = new Vector();
        }
        return this.orderedChangeObjectList;
    }

    public Vector getOrderedRemoveObjectIndices() {
        if (this.orderedRemoveObjectIndices == null) {
            this.orderedRemoveObjectIndices = new Vector();
        }
        return this.orderedRemoveObjectIndices;
    }

    public Object getOrderedRemoveObject(Integer n) {
        return this.getOrderedRemoveObjects().get(n);
    }

    public Hashtable getOrderedRemoveObjects() {
        if (this.orderedRemoveObjects == null) {
            this.orderedRemoveObjects = new Hashtable();
        }
        return this.orderedRemoveObjects;
    }

    public void setOrderedAddObjectIndices(Map map) {
        this.orderedAddObjectIndices = map;
    }

    public void setOrderedAddObjects(Vector vector) {
        this.orderedAddObjects = vector;
    }

    public void setOrderedChangeObjectList(Vector vector) {
        this.orderedChangeObjectList = vector;
    }

    public void setOrderedRemoveObjects(Hashtable hashtable) {
        this.orderedRemoveObjects = hashtable;
    }
}

