/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Map;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ExclusiveIsolatedClientSession
extends IsolatedClientSession {
    protected boolean shouldAlwaysUseExclusiveConnection;

    public ExclusiveIsolatedClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy) {
        this(serverSession, connectionPolicy, null);
    }

    public ExclusiveIsolatedClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy, Map map) {
        super(serverSession, connectionPolicy, map);
        this.accessor = null;
        this.shouldAlwaysUseExclusiveConnection = connectionPolicy.isExclusiveAlways();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord abstractRecord, DatabaseQuery databaseQuery) throws DatabaseException {
        Object object;
        block6: {
            if (databaseQuery.getAccessor() == null) {
                if (this.getAccessor() == null) {
                    this.getParent().acquireClientConnection(this);
                }
                databaseQuery.setAccessor(this.getAccessor());
            }
            try {
                object = databaseQuery.getAccessor().executeCall(call, abstractRecord, this);
                Object var6_5 = null;
                if (!call.isFinished()) break block6;
                databaseQuery.setAccessor(null);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (call.isFinished()) {
                        databaseQuery.setAccessor(null);
                    }
                    if (this.isActive() || this.getAccessor() == null) break block7;
                    this.getParent().releaseClientSession(this);
                }
                throw throwable;
            }
        }
        if (!this.isActive() && this.getAccessor() != null) {
            this.getParent().releaseClientSession(this);
        }
        return object;
    }

    public Accessor getAccessor() {
        return this.writeConnection;
    }

    public void setAccessor(Accessor accessor) {
        this.setWriteConnection(accessor);
    }

    protected void releaseWriteConnection() {
    }

    public void postConnectExternalConnection(Accessor accessor) {
        super.postConnectExternalConnection(accessor);
        this.getParent().getEventManager().postAcquireExclusiveConnection(this, accessor);
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        super.preDisconnectExternalConnection(accessor);
        this.getParent().getEventManager().preReleaseExclusiveConnection(this, accessor);
    }

    public boolean isExclusiveConnectionRequired() {
        return this.isActive();
    }

    public boolean isExclusiveIsolatedClientSession() {
        return true;
    }

    protected boolean shouldExecuteLocally(DatabaseQuery databaseQuery) {
        if (this.shouldAlwaysUseExclusiveConnection) {
            return true;
        }
        return super.shouldExecuteLocally(databaseQuery);
    }
}

