/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Map;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSessionIdentityMapAccessor;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class IsolatedClientSession
extends ClientSession {
    public IsolatedClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy) {
        super(serverSession, connectionPolicy);
    }

    public IsolatedClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy, Map map) {
        super(serverSession, connectionPolicy, map);
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IsolatedClientSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    protected boolean shouldExecuteLocally(DatabaseQuery databaseQuery) {
        if (this.isIsolatedQuery(databaseQuery)) {
            return true;
        }
        return this.isInTransaction();
    }

    protected boolean isIsolatedQuery(DatabaseQuery databaseQuery) {
        databaseQuery.checkDescriptor(this);
        return databaseQuery.isDataModifyQuery() || databaseQuery.isDataReadQuery() || databaseQuery.getDescriptor() != null && databaseQuery.getDescriptor().isIsolated() || databaseQuery.isObjectBuildingQuery() && ((ObjectBuildingQuery)databaseQuery).shouldUseExclusiveConnection();
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        if (databaseQuery != null && this.isIsolatedQuery(databaseQuery)) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(databaseQuery, bl, bl2);
    }

    public AbstractSession getExecutionSession(DatabaseQuery databaseQuery) {
        if (this.shouldExecuteLocally(databaseQuery)) {
            return this;
        }
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public Object executeCall(Call call, AbstractRecord abstractRecord, DatabaseQuery databaseQuery) throws DatabaseException {
        if (this.isInTransaction()) {
            return super.executeCall(call, abstractRecord, databaseQuery);
        }
        return this.getParent().executeCall(call, abstractRecord, databaseQuery);
    }

    public boolean isIsolatedClientSession() {
        return true;
    }
}

