/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories;

import org.eclipse.persistence.internal.sessions.factories.NamespaceResolverWithPrefixes;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sessions.Project;

public abstract class NamespaceResolvableProject
extends Project {
    public static final String ECLIPSELINK_PREFIX = "eclipselink";
    public static final String ECLIPSELINK_NAMESPACE = "http://www.eclipse.org/eclipselink/xsds/persistence";
    public static final String TOPLINK_PREFIX = "toplink";
    public static final String TOPLINK_NAMESPACE = "http://xmlns.oracle.com/ias/xsds/toplink";
    public static final String OPM_PREFIX = "opm";
    public static final String OPM_NAMESPACE = "http://xmlns.oracle.com/ias/xsds/opm";
    protected NamespaceResolverWithPrefixes ns;

    public NamespaceResolvableProject() {
        this.buildNamespaceResolver();
        this.buildDescriptors();
        this.setNamespaceResolverOnDescriptors();
    }

    public NamespaceResolvableProject(NamespaceResolverWithPrefixes namespaceResolverWithPrefixes) {
        this.ns = namespaceResolverWithPrefixes;
        this.buildDescriptors();
        this.setNamespaceResolverOnDescriptors();
    }

    public NamespaceResolverWithPrefixes getNamespaceResolver() {
        return this.ns;
    }

    protected void buildNamespaceResolver() {
        String string;
        this.ns = new NamespaceResolverWithPrefixes();
        this.ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
        String string2 = this.getPrimaryNamespacePrefix();
        if (string2 != null && string2.length() > 0) {
            this.ns.putPrimary(string2, this.getPrimaryNamespace());
        }
        if ((string = this.getSecondaryNamespacePrefix()) != null && string.length() > 0) {
            this.ns.putSecondary(string, this.getSecondaryNamespace());
        }
    }

    public String getPrimaryNamespacePrefix() {
        return null;
    }

    public String getPrimaryNamespace() {
        return null;
    }

    public String getPrimaryNamespaceXPath() {
        if (this.ns.getPrimaryPrefix() != null) {
            return this.ns.getPrimaryPrefix() + ":";
        }
        return "";
    }

    public String resolvePrimaryNamespace() {
        return this.ns.resolveNamespacePrefix(this.ns.getPrimaryPrefix());
    }

    public String getSecondaryNamespacePrefix() {
        return null;
    }

    public String getSecondaryNamespace() {
        return null;
    }

    public String getSecondaryNamespaceXPath() {
        if (this.ns.getSecondaryPrefix() != null) {
            return this.ns.getSecondaryPrefix() + ":";
        }
        return "";
    }

    public String resolveSecondaryNamespace() {
        return this.ns.resolveNamespacePrefix(this.ns.getSecondaryPrefix());
    }

    protected abstract void buildDescriptors();

    protected void setNamespaceResolverOnDescriptors() {
        for (XMLDescriptor xMLDescriptor : this.getDescriptors().values()) {
            xMLDescriptor.setNamespaceResolver(this.ns);
        }
    }
}

