/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories.model.login;

import java.util.Vector;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;

public abstract class LoginConfig {
    private String m_platformClass;
    private String m_username;
    private char[] m_encryptedPassword;
    private SecurableObjectHolder m_securableObjectHolder = new SecurableObjectHolder();
    private String m_tableQualifier;
    private String m_encryptionClass;
    private boolean m_externalConnectionPooling;
    private boolean m_externalTransactionController;
    private SequencingConfig m_sequencingConfig;
    private Vector m_propertyConfigs;

    public void setPlatformClass(String string) {
        this.m_platformClass = string;
    }

    public String getPlatformClass() {
        return this.m_platformClass;
    }

    public void setUsername(String string) {
        this.m_username = string;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setEncryptionClass(String string) {
        this.m_encryptionClass = string;
        this.m_securableObjectHolder.setEncryptionClassName(this.m_encryptionClass);
    }

    public String getEncryptionClass() {
        return this.m_encryptionClass;
    }

    public void setPassword(String string) {
        if (string == null) {
            this.m_encryptedPassword = null;
        } else if (string.length() == 0) {
            this.m_encryptedPassword = new char[0];
        } else {
            String string2 = this.m_securableObjectHolder.getSecurableObject().encryptPassword(string);
            this.m_encryptedPassword = string2.toCharArray();
        }
    }

    public void setEncryptedPassword(String string) {
        this.m_encryptedPassword = (char[])(string != null ? string.toCharArray() : null);
    }

    public String getPassword() {
        String string = null;
        if (this.m_encryptedPassword != null) {
            String string2 = new String(this.m_encryptedPassword);
            string = this.m_securableObjectHolder.getSecurableObject().decryptPassword(string2);
            if (string == null || string.equals(string2)) {
                this.setPassword(string);
            }
        }
        return string;
    }

    public String getEncryptedPassword() {
        if (this.m_encryptedPassword != null) {
            return new String(this.m_encryptedPassword);
        }
        return null;
    }

    public void setTableQualifier(String string) {
        this.m_tableQualifier = string;
    }

    public String getTableQualifier() {
        return this.m_tableQualifier;
    }

    public void setExternalConnectionPooling(boolean bl) {
        this.m_externalConnectionPooling = bl;
    }

    public boolean getExternalConnectionPooling() {
        return this.m_externalConnectionPooling;
    }

    public void setExternalTransactionController(boolean bl) {
        this.m_externalTransactionController = bl;
    }

    public boolean getExternalTransactionController() {
        return this.m_externalTransactionController;
    }

    public void setSequencingConfig(SequencingConfig sequencingConfig) {
        this.m_sequencingConfig = sequencingConfig;
    }

    public SequencingConfig getSequencingConfig() {
        return this.m_sequencingConfig;
    }

    public void setPropertyConfigs(Vector vector) {
        this.m_propertyConfigs = vector;
    }

    public Vector getPropertyConfigs() {
        return this.m_propertyConfigs;
    }
}

