/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class DefaultSessionLog
extends AbstractSessionLog
implements Serializable {
    protected String fileName;
    private Map<String, Integer> categoryLogLevelMap = new HashMap<String, Integer>();

    public DefaultSessionLog() {
        for (int i = 0; i < loggerCatagories.length; ++i) {
            String string = loggerCatagories[i];
            this.categoryLogLevelMap.put(string, null);
        }
    }

    public DefaultSessionLog(Writer writer) {
        this();
        this.initialize(writer);
    }

    public void setLevel(int n, String string) {
        if (string == null) {
            this.level = n;
        } else if (this.categoryLogLevelMap.containsKey(string)) {
            this.categoryLogLevelMap.put(string, n);
        }
    }

    public boolean shouldLog(int n, String string) {
        return this.getLevel(string) <= n;
    }

    protected void initialize() {
        this.setShouldPrintSession(true);
        this.setShouldPrintConnection(true);
    }

    protected void initialize(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(SessionLogEntry sessionLogEntry) {
        if (!this.shouldLog(sessionLogEntry.getLevel(), sessionLogEntry.getNameSpace())) {
            return;
        }
        DefaultSessionLog defaultSessionLog = this;
        synchronized (defaultSessionLog) {
            try {
                this.printPrefixString(sessionLogEntry.getLevel());
                this.getWriter().write(this.getSupplementDetailString(sessionLogEntry));
                if (sessionLogEntry.hasException()) {
                    if (sessionLogEntry.getLevel() == 7) {
                        sessionLogEntry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                    } else if (sessionLogEntry.getLevel() <= 6) {
                        if (this.shouldLogExceptionStackTrace()) {
                            sessionLogEntry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                        } else {
                            this.writeMessage(sessionLogEntry.getException().toString());
                        }
                    }
                } else {
                    this.writeMessage(this.formatMessage(sessionLogEntry));
                }
                this.getWriter().write(Helper.cr());
                this.getWriter().flush();
            }
            catch (IOException iOException) {
                throw ValidationException.logIOError(iOException);
            }
        }
    }

    public void setWriter(String string) {
        if (string != null) {
            try {
                this.writer = new FileWriter(string);
                this.fileName = string;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String getWriterFilename() {
        return this.fileName;
    }

    protected void writeMessage(String string) throws IOException {
        this.getWriter().write(string);
    }

    protected void writeSeparator() throws IOException {
        this.getWriter().write("--");
    }
}

