/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.EclipseLinkLogRecord;
import org.eclipse.persistence.logging.LogFormatter;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.Session;

public class JavaLog
extends AbstractSessionLog {
    public static final String TOPLINK_NAMESPACE = "org.eclipse.persistence";
    protected static final String LOGGING_LOCALIZATION_STRING = "org.eclipse.persistence.internal.localization.i18n.LoggingLocalizationResource";
    protected static final String TRACE_LOCALIZATION_STRING = "org.eclipse.persistence.internal.localization.i18n.TraceLocalizationResource";
    public static final String DEFAULT_TOPLINK_NAMESPACE = "org.eclipse.persistence.default";
    public static final String SESSION_TOPLINK_NAMESPACE = "org.eclipse.persistence.session";
    private static final Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private Map nameSpaceMap = new HashMap();
    private String sessionNameSpace;
    private Logger sessionLogger;
    private Map categoryloggers = new HashMap();

    public JavaLog() {
        this.addLogger(DEFAULT_TOPLINK_NAMESPACE, DEFAULT_TOPLINK_NAMESPACE);
    }

    protected void addLogger(String string, String string2) {
        this.categoryloggers.put(string, Logger.getLogger(string2));
    }

    public Map getCategoryLoggers() {
        return this.categoryloggers;
    }

    public int getLevel(String string) {
        Logger logger;
        for (logger = this.getLogger(string); logger != null && logger.getLevel() == null; logger = logger.getParent()) {
        }
        if (logger == null) {
            return 8;
        }
        int n = logger.getLevel().intValue();
        for (int i = 0; i < levels.length; ++i) {
            if (n != levels[i].intValue()) continue;
            return i;
        }
        return 8;
    }

    public void setLevel(final int n, String string) {
        final Logger logger = this.getLogger(string);
        if (logger == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(JavaLog.this.getJavaLevel(n));
                return null;
            }
        });
    }

    public void setWriter(OutputStream outputStream) {
        StreamHandler streamHandler = new StreamHandler(outputStream, new LogFormatter());
        ((Logger)this.categoryloggers.get(DEFAULT_TOPLINK_NAMESPACE)).addHandler(streamHandler);
        if (this.sessionLogger != null) {
            this.sessionLogger.addHandler(streamHandler);
        }
    }

    protected String getNameSpaceString(String string) {
        if (this.session == null) {
            return DEFAULT_TOPLINK_NAMESPACE;
        }
        if (string == null || string.length() == 0) {
            return this.sessionNameSpace;
        }
        return (String)this.nameSpaceMap.get(string);
    }

    protected Logger getLogger(String string) {
        if (this.session == null) {
            return (Logger)this.categoryloggers.get(DEFAULT_TOPLINK_NAMESPACE);
        }
        if (string == null || string.length() == 0) {
            return (Logger)this.categoryloggers.get(this.sessionNameSpace);
        }
        Logger logger = (Logger)this.categoryloggers.get(string);
        assert (logger != null);
        return logger;
    }

    public void setSession(Session session) {
        super.setSession(session);
        if (session != null) {
            String string = session.getName();
            this.sessionNameSpace = string != null && string.length() != 0 ? "org.eclipse.persistence.session." + string : DEFAULT_TOPLINK_NAMESPACE;
            this.addLogger(this.sessionNameSpace, this.sessionNameSpace);
            for (int i = 0; i < loggerCatagories.length; ++i) {
                String string2 = loggerCatagories[i];
                String string3 = this.sessionNameSpace + "." + string2;
                this.nameSpaceMap.put(string2, string3);
                this.addLogger(string2, string3);
            }
        }
    }

    protected Level getJavaLevel(int n) {
        return levels[n];
    }

    public boolean shouldLog(int n, String string) {
        Logger logger = this.getLogger(string);
        return logger.isLoggable(this.getJavaLevel(n));
    }

    public void log(SessionLogEntry sessionLogEntry) {
        if (!this.shouldLog(sessionLogEntry.getLevel(), sessionLogEntry.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(sessionLogEntry.getNameSpace());
        Level level = this.getJavaLevel(sessionLogEntry.getLevel());
        this.internalLog(sessionLogEntry, level, logger);
    }

    protected void internalLog(SessionLogEntry sessionLogEntry, Level level, Logger logger) {
        EclipseLinkLogRecord eclipseLinkLogRecord = new EclipseLinkLogRecord(level, this.formatMessage(sessionLogEntry));
        eclipseLinkLogRecord.setSourceClassName(null);
        eclipseLinkLogRecord.setSourceMethodName(null);
        eclipseLinkLogRecord.setLoggerName(this.getNameSpaceString(sessionLogEntry.getNameSpace()));
        if (this.shouldPrintSession()) {
            eclipseLinkLogRecord.setSessionString(this.getSessionString(sessionLogEntry.getSession()));
        }
        if (this.shouldPrintConnection()) {
            eclipseLinkLogRecord.setConnection(sessionLogEntry.getConnection());
        }
        eclipseLinkLogRecord.setThrown(sessionLogEntry.getException());
        eclipseLinkLogRecord.setShouldLogExceptionStackTrace(this.shouldLogExceptionStackTrace());
        eclipseLinkLogRecord.setShouldPrintDate(this.shouldPrintDate());
        eclipseLinkLogRecord.setShouldPrintThread(this.shouldPrintThread());
        logger.log(eclipseLinkLogRecord);
    }

    public void throwing(Throwable throwable) {
        this.getLogger(null).throwing(null, null, throwable);
    }

    public Object clone() {
        JavaLog javaLog = (JavaLog)super.clone();
        return javaLog;
    }
}

