/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class CollectionMapping
extends ForeignReferenceMapping
implements ContainerMapping {
    protected transient ModifyQuery deleteAllQuery;
    protected transient boolean hasCustomDeleteAllQuery;
    protected ContainerPolicy containerPolicy;
    protected transient boolean hasOrderBy;

    public CollectionMapping() {
        this.selectionQuery = new ReadAllQuery();
        this.hasCustomDeleteAllQuery = false;
        this.containerPolicy = ContainerPolicy.buildDefaultPolicy();
        this.hasOrderBy = false;
    }

    public void addAscendingOrdering(String string) {
        this.hasOrderBy = true;
        if (string == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addAscendingOrdering(string);
    }

    public void addDescendingOrdering(String string) {
        this.hasOrderBy = true;
        if (string == null) {
            return;
        }
        ((ReadAllQuery)this.getSelectionQuery()).addDescendingOrdering(string);
    }

    public void addOrderBy(String string, boolean bl) {
        if (bl) {
            this.addDescendingOrdering(string);
        } else {
            this.addAscendingOrdering(string);
        }
    }

    public void addAggregateOrderBy(String string, String string2, boolean bl) {
        this.hasOrderBy = true;
        ReadAllQuery readAllQuery = (ReadAllQuery)this.getSelectionQuery();
        ExpressionBuilder expressionBuilder = readAllQuery.getExpressionBuilder();
        Expression expression = null;
        if (string.contains(".")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                if (expression == null) {
                    expression = expressionBuilder.get(stringTokenizer.nextToken());
                    continue;
                }
                expression = expression.get(stringTokenizer.nextToken());
            }
            expression = expression.get(string2);
        } else {
            expression = expressionBuilder.get(string).get(string2);
        }
        if (bl) {
            readAllQuery.addOrdering(expression.descending());
        } else {
            readAllQuery.addOrdering(expression.ascending());
        }
    }

    public Object buildBackupCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        if (object == null) {
            return this.getContainerPolicy().containerInstance(1);
        }
        return this.getContainerPolicy().cloneFor(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object == null) {
            Object object4 = containerPolicy.containerInstance(1);
            if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && object3 != null && ((ChangeTracker)object3)._persistence_getPropertyChangeListener() != null && object4 instanceof CollectionChangeTracker) {
                ((CollectionChangeTracker)object4).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)object4)._persistence_setPropertyChangeListener(((ChangeTracker)object3)._persistence_getPropertyChangeListener());
            }
            return object4;
        }
        Object object5 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object6 = null;
        Object object7 = object;
        synchronized (object7) {
            object6 = containerPolicy.cloneFor(object);
        }
        object7 = containerPolicy.iteratorFor(object6);
        while (containerPolicy.hasNext(object7)) {
            containerPolicy.addNextValueFromIteratorInto(object7, object3, object5, this, unitOfWorkImpl, bl);
        }
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && object3 != null && ((ChangeTracker)object3)._persistence_getPropertyChangeListener() != null && object5 instanceof CollectionChangeTracker) {
            ((CollectionChangeTracker)object5).setTrackedAttributeName(this.getAttributeName());
            ((CollectionChangeTracker)object5)._persistence_setPropertyChangeListener(((ChangeTracker)object3)._persistence_getPropertyChangeListener());
        }
        return object5;
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object2, objectCopyingPolicy.getSession());
        Object object4 = this.getContainerPolicy().iteratorFor(object3);
        object3 = this.getContainerPolicy().containerInstance(this.getContainerPolicy().sizeFor(object3));
        while (this.getContainerPolicy().hasNext(object4)) {
            Object object5;
            Object object6 = object5 = this.getContainerPolicy().next(object4, objectCopyingPolicy.getSession());
            if (objectCopyingPolicy.shouldCascadeAllParts() || objectCopyingPolicy.shouldCascadePrivateParts() && this.isPrivateOwned()) {
                object6 = objectCopyingPolicy.getSession().copyObject(object5, objectCopyingPolicy);
            } else {
                object6 = objectCopyingPolicy.getCopies().get(object5);
                if (object6 == null) {
                    object6 = object5;
                }
            }
            this.getContainerPolicy().addInto(object6, object3, objectCopyingPolicy.getSession());
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    public Object buildElementClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        if (bl) {
            return unitOfWorkImpl.registerExistingObject(object);
        }
        return unitOfWorkImpl.registerObject(object);
    }

    public Object[] buildReferencesPKList(Object object, Object object2, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        Object object3 = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, object2);
        Object[] objectArray = new Object[this.getContainerPolicy().sizeFor(object3)];
        Iterator iterator = (Iterator)this.getContainerPolicy().iteratorFor(object3);
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(e, abstractSession);
            CMPPolicy cMPPolicy = classDescriptor.getCMPPolicy();
            objectArray[n] = cMPPolicy != null && cMPPolicy.isCMP3Policy() ? cMPPolicy.createPrimaryKeyInstance(vector) : vector;
            ++n;
        }
        return objectArray;
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null || !this.isCascadeRemove()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.nextEntry(object4, unitOfWorkImpl);
            Object object6 = containerPolicy.unwrapIteratorResult(object5);
            if (object6 == null || map.containsKey(object6)) continue;
            map.put(object6, object6);
            unitOfWorkImpl.performRemove(object6, map);
            containerPolicy.cascadePerformRemoveIfRequired(object5, unitOfWorkImpl, map);
        }
    }

    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 != null && this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            Object object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object4 = containerPolicy.iteratorFor(object3);
            while (containerPolicy.hasNext(object4)) {
                Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
                if (object5 == null || map.containsKey(object5)) continue;
                map.put(object5, object5);
                unitOfWorkImpl.performRemovePrivateOwnedObjectFromChangeSet(object5, map);
            }
        }
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null || !this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            IndirectCollection indirectCollection;
            if (object2 instanceof IndirectCollection && (indirectCollection = (IndirectCollection)object2).hasDeferredChanges()) {
                Iterator iterator = indirectCollection.getAddedElements().iterator();
                boolean bl = this.isCascadePersist();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (unitOfWorkImpl.hasPrivateOwnedObjects()) {
                        unitOfWorkImpl.removePrivateOwnedObject(this, e);
                    }
                    unitOfWorkImpl.discoverAndPersistUnregisteredNewObjects(e, bl, map, map2, map3);
                }
            }
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        boolean bl = this.isCascadePersist();
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.nextEntry(object4, unitOfWorkImpl);
            Object object6 = containerPolicy.unwrapIteratorResult(object5);
            if (unitOfWorkImpl.hasPrivateOwnedObjects()) {
                unitOfWorkImpl.removePrivateOwnedObject(this, object6);
            }
            unitOfWorkImpl.discoverAndPersistUnregisteredNewObjects(object6, bl, map, map2, map3);
            containerPolicy.cascadeDiscoverAndPersistUnregisteredNewObjects(object5, map, map2, map3, unitOfWorkImpl);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null || !this.isCascadePersist() || !this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.nextEntry(object4, unitOfWorkImpl);
            Object object6 = containerPolicy.unwrapIteratorResult(object5);
            if (this.isCandidateForPrivateOwnedRemoval() && unitOfWorkImpl.shouldDiscoverNewObjects()) {
                unitOfWorkImpl.addPrivateOwnedObject(this, object6);
            }
            unitOfWorkImpl.registerNewObjectForPersist(object6, map);
            containerPolicy.cascadeRegisterNewIfRequired(object5, unitOfWorkImpl, map);
        }
    }

    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession abstractSession) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionChangeRecord.getOriginalCollection(), collectionChangeRecord.getLatestCollection(), collectionChangeRecord, abstractSession);
    }

    public void cascadeMerge(Object object, MergeManager mergeManager) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            mergeManager.mergeChanges(mergeManager.getObjectToMerge(object), null);
        }
    }

    public Object clone() {
        CollectionMapping collectionMapping = (CollectionMapping)super.clone();
        collectionMapping.setDeleteAllQuery((ModifyQuery)this.getDeleteAllQuery().clone());
        return collectionMapping;
    }

    public void compareCollectionsForChange(Object object, Object object2, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession abstractSession) {
        this.getContainerPolicy().compareCollectionsForChange(object, object2, (CollectionChangeRecord)changeRecord, abstractSession, this.getReferenceDescriptor());
    }

    public org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        object3 = this.getAttributeValueFromObject(object);
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object3 == null && object4 == null) {
                return null;
            }
            object5 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
        }
        Object object6 = null;
        object6 = object3 != null ? this.getRealCollectionAttributeValueFromObject(object, abstractSession) : this.getContainerPolicy().containerInstance(1);
        CollectionChangeRecord collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
        collectionChangeRecord.setAttribute(this.getAttributeName());
        collectionChangeRecord.setMapping(this);
        this.compareCollectionsForChange(object5, object6, collectionChangeRecord, abstractSession);
        if (collectionChangeRecord.hasChanges()) {
            return collectionChangeRecord;
        }
        return null;
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        Object object4 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
        return super.compareObjects(object3, object4, abstractSession);
    }

    protected void compareObjectsAndWrite(Object object, Object object2, WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Cloneable cloneable;
        Object object3;
        Object object4;
        Object object5;
        if (writeObjectQuery.getObjectChangeSet() != null && !this.isAggregateCollectionMapping()) {
            ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
            CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
            if (collectionChangeRecord != null) {
                ObjectChangeSet objectChangeSet22 = null;
                ObjectChangeSet objectChangeSet32 = null;
                for (ObjectChangeSet objectChangeSet22 : collectionChangeRecord.getRemoveObjectList().values()) {
                    this.objectRemovedDuringUpdate(writeObjectQuery, this.getContainerPolicy().getCloneDataFromChangeSet(objectChangeSet22), null);
                    if (objectChangeSet22.getOldKey() == null) continue;
                    this.containerPolicy.propogatePostUpdate(writeObjectQuery, objectChangeSet22.getOldKey());
                }
                for (ObjectChangeSet objectChangeSet32 : collectionChangeRecord.getAddObjectList().values()) {
                    this.objectAddedDuringUpdate(writeObjectQuery, this.getContainerPolicy().getCloneDataFromChangeSet(objectChangeSet32), objectChangeSet32, null);
                    if (objectChangeSet32.getNewKey() == null) continue;
                    this.containerPolicy.propogatePostUpdate(writeObjectQuery, objectChangeSet32.getNewKey());
                }
            }
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Hashtable<CacheKey, Object> hashtable = new Hashtable<CacheKey, Object>(containerPolicy.sizeFor(object) + 2);
        Hashtable<CacheKey, Object> hashtable2 = new Hashtable<CacheKey, Object>(containerPolicy.sizeFor(object2) + 2);
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>(containerPolicy.sizeFor(object2) + 1);
        Object object6 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object6)) {
            object5 = containerPolicy.next(object6, writeObjectQuery.getSession());
            try {
                object4 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object5, writeObjectQuery.getSession());
                object3 = new CacheKey((Vector)object4);
                hashtable2.put((CacheKey)object3, object5);
                identityHashMap.put(object5, object3);
            }
            catch (NullPointerException nullPointerException) {
                if (object5 == null) continue;
                throw nullPointerException;
            }
        }
        object6 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object6)) {
            object5 = containerPolicy.nextEntry(object6, writeObjectQuery.getSession());
            object4 = this.containerPolicy.getKeyMappingDataForWriteQuery(object5, writeObjectQuery.getSession());
            object3 = this.containerPolicy.unwrapIteratorResult(object5);
            cloneable = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object3, writeObjectQuery.getSession());
            CacheKey cacheKey = new CacheKey((Vector)cloneable);
            hashtable.put(cacheKey, object3);
            if (hashtable2.containsKey(cacheKey)) continue;
            this.objectRemovedDuringUpdate(writeObjectQuery, object5, (Map)object4);
            containerPolicy.propogatePostUpdate(writeObjectQuery, object5);
        }
        object6 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object6)) {
            object5 = containerPolicy.nextEntry(object6, writeObjectQuery.getSession());
            object4 = this.containerPolicy.unwrapIteratorResult(object5);
            try {
                object3 = this.containerPolicy.getKeyMappingDataForWriteQuery(object5, writeObjectQuery.getSession());
                cloneable = (CacheKey)identityHashMap.get(object4);
                if (!hashtable.containsKey(cloneable)) {
                    this.objectAddedDuringUpdate(writeObjectQuery, object4, null, (Map)object3);
                    containerPolicy.propogatePostUpdate(writeObjectQuery, object5);
                    continue;
                }
                this.objectUnchangedDuringUpdate(writeObjectQuery, object4, hashtable, (CacheKey)cloneable);
            }
            catch (NullPointerException nullPointerException) {
                if (object4 == null) continue;
                throw nullPointerException;
            }
        }
    }

    protected boolean compareObjectsWithoutPrivateOwned(Object object, Object object2, AbstractSession abstractSession) {
        Vector vector;
        Object object3;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object) != containerPolicy.sizeFor(object2)) {
            return false;
        }
        Object object4 = containerPolicy.iteratorFor(object);
        Object object5 = containerPolicy.iteratorFor(object2);
        Vector<CacheKey> vector2 = new Vector<CacheKey>();
        while (containerPolicy.hasNext(object5)) {
            object3 = containerPolicy.next(object5, abstractSession);
            vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object3, abstractSession);
            vector2.addElement(new CacheKey(vector));
        }
        while (containerPolicy.hasNext(object4)) {
            object3 = containerPolicy.next(object4, abstractSession);
            vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object3, abstractSession);
            if (vector2.contains(new CacheKey(vector))) continue;
            return false;
        }
        return true;
    }

    protected boolean compareObjectsWithPrivateOwned(Object object, Object object2, AbstractSession abstractSession) {
        Vector vector;
        Object object3;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object) != containerPolicy.sizeFor(object2)) {
            return false;
        }
        Object object4 = containerPolicy.iteratorFor(object);
        Object object5 = containerPolicy.iteratorFor(object2);
        Hashtable<CacheKey, Object> hashtable = new Hashtable<CacheKey, Object>(containerPolicy.sizeFor(object) + 2);
        while (containerPolicy.hasNext(object5)) {
            object3 = containerPolicy.next(object5, abstractSession);
            vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object3, abstractSession);
            hashtable.put(new CacheKey(vector), object3);
        }
        while (containerPolicy.hasNext(object4)) {
            object3 = containerPolicy.next(object4, abstractSession);
            vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object3, abstractSession);
            CacheKey cacheKey = new CacheKey(vector);
            if (hashtable.containsKey(cacheKey)) {
                Object v = hashtable.get(cacheKey);
                if (abstractSession.compareObjects(object3, v)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.containerPolicy.convertClassNamesToClasses(classLoader);
    }

    public void fixRealObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getRealAttributeValueFromObject(object, remoteSession);
        if (object2 == null) {
            this.setAttributeValueInObject(object, null);
            return;
        }
        ObjectLevelReadQuery objectLevelReadQuery2 = objectLevelReadQuery;
        if (!objectLevelReadQuery2.shouldMaintainCache() && (!objectLevelReadQuery2.shouldCascadeParts() || objectLevelReadQuery2.shouldCascadePrivateParts() && !this.isPrivateOwned())) {
            objectLevelReadQuery2 = null;
        }
        Object object3 = remoteSession.getObjectsCorrespondingToAll(object2, map, map2, objectLevelReadQuery2, this.getContainerPolicy());
        this.setRealAttributeValueInObject(object, object3);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    protected ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        Expression expression = this.getSelectionCriteria();
        Expression expression2 = this.containerPolicy.getKeySelectionCriteria();
        if (expression2 != null) {
            expression = expression.and(expression2);
        }
        return queryKeyExpression.getBaseExpression().twist(expression, queryKeyExpression);
    }

    public Object getObjectCorrespondingTo(Object object, RemoteSession remoteSession, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery) {
        return remoteSession.getObjectsCorrespondingToAll(object, map, map2, objectLevelReadQuery, this.getContainerPolicy());
    }

    public Vector getOrderByQueryKeyExpressions() {
        Vector<Expression> vector = new Vector<Expression>();
        if (this.getSelectionQuery() != null && this.getSelectionQuery().isReadAllQuery()) {
            Enumeration enumeration = ((ReadAllQuery)this.getSelectionQuery()).getOrderByExpressions().elements();
            while (enumeration.hasMoreElements()) {
                Expression expression = (Expression)enumeration.nextElement();
                if (!expression.isFunctionExpression() || !((FunctionExpression)expression).getBaseExpression().isQueryKeyExpression()) continue;
                vector.add(expression);
            }
        }
        return vector;
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession abstractSession) throws DescriptorException {
        Object object2 = this.getRealAttributeValueFromObject(object, abstractSession);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        return object2;
    }

    protected boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    public boolean hasOrderBy() {
        return this.hasOrderBy;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        this.setFields(this.collectFields());
        this.getContainerPolicy().prepare(this.getSelectionQuery(), abstractSession);
        if (!this.usesIndirection() && !this.getAttributeAccessor().getAttributeClass().isAssignableFrom(this.getContainerPolicy().getContainerClass())) {
            throw DescriptorException.incorrectCollectionPolicy(this, this.getAttributeAccessor().getAttributeClass(), this.getContainerPolicy().getContainerClass());
        }
    }

    public boolean isCollectionMapping() {
        return true;
    }

    public boolean isAttributeValueInstantiatedOrChanged(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiatedOrChanged(this.getAttributeValueFromObject(object));
    }

    public void iterateOnElement(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iterateReferenceObjectForMapping(object, this);
    }

    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Object object3 = containerPolicy.nextEntry(object2, descriptorIterator.getSession());
            Object object4 = containerPolicy.unwrapIteratorResult(object3);
            this.iterateOnElement(descriptorIterator, object4);
            containerPolicy.iterateOnMapKey(descriptorIterator, object3);
        }
    }

    protected boolean mustDeleteReferenceObjectsOneByOne() {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        return classDescriptor.hasDependencyOnParts() || classDescriptor.usesOptimisticLocking() || classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().shouldReadSubclasses() || classDescriptor.hasMultipleTables() || this.containerPolicy.propagatesEventsToCollection();
    }

    public void mergeChangesIntoObject(Object object, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        Object object3 = null;
        Object object4 = null;
        AbstractSession abstractSession = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet();
        if (this.isAttributeValueInstantiated(object)) {
            object3 = collectionChangeRecord.getOwner().isNew() ? containerPolicy.containerInstance(collectionChangeRecord.getAddObjectList().size()) : this.getRealCollectionAttributeValueFromObject(object, mergeManager.getSession());
            abstractSession = mergeManager.getSession().isUnitOfWork() ? ((UnitOfWorkImpl)mergeManager.getSession()).getParent() : mergeManager.getSession();
            containerPolicy.mergeChanges(collectionChangeRecord, object3, this.shouldMergeCascadeParts(mergeManager), mergeManager, abstractSession);
        } else {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            if (!this.isAttributeValueInstantiated(object2)) {
                return;
            }
            object4 = this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
            Object object5 = containerPolicy.iteratorFor(object4);
            object3 = containerPolicy.containerInstance(containerPolicy.sizeFor(object4));
            while (containerPolicy.hasNext(object5)) {
                Object object6 = containerPolicy.next(object5, mergeManager.getSession());
                if (this.shouldMergeCascadeParts(mergeManager) && object4 != null) {
                    ObjectChangeSet objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object6);
                    mergeManager.mergeChanges(object6, objectChangeSet);
                }
                containerPolicy.addInto(mergeManager.getTargetVersionOfSourceObject(object6), object3, mergeManager.getSession());
            }
        }
        if (object3 == null) {
            object3 = containerPolicy.containerInstance();
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3;
        Object object4;
        Object object5;
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            if (!this.isAttributeValueInstantiated(object)) {
                Object object6 = this.getAttributeValueFromObject(object2);
                Object object7 = this.getIndirectionPolicy().cloneAttribute(object6, object2, object, (UnitOfWorkImpl)mergeManager.getSession(), false);
                this.setAttributeValueInObject(object, object7);
                return;
            }
        } else if (!this.isAttributeValueInstantiatedOrChanged(object2)) {
            return;
        }
        Object object8 = this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
        AbstractSession abstractSession = mergeManager.getSession();
        Object object9 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        containerPolicy.sizeFor(object9);
        boolean bl2 = false;
        if (!mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            object5 = containerPolicy.containerInstance(containerPolicy.sizeFor(object8));
            if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy() && object instanceof ChangeTracker && ((ChangeTracker)object)._persistence_getPropertyChangeListener() != null) {
                bl2 = object8 != object9;
                object4 = containerPolicy.iteratorFor(object9);
                object3 = ((ChangeTracker)object)._persistence_getPropertyChangeListener();
                if (bl2) {
                    while (containerPolicy.hasNext(object4)) {
                        ((ObjectChangeListener)object3).internalPropertyChange(new CollectionChangeEvent(object, this.getAttributeName(), object9, containerPolicy.next(object4, abstractSession), CollectionChangeEvent.REMOVE));
                    }
                }
                if (object5 instanceof ChangeTracker) {
                    ((CollectionChangeTracker)object5).setTrackedAttributeName(this.getAttributeName());
                    ((CollectionChangeTracker)object5)._persistence_setPropertyChangeListener((PropertyChangeListener)object3);
                }
                if (object9 instanceof ChangeTracker) {
                    ((ChangeTracker)object9)._persistence_setPropertyChangeListener(null);
                }
            }
            object9 = object5;
        } else {
            this.setRealAttributeValueInObject(object, containerPolicy.containerInstance(containerPolicy.sizeFor(object8)));
            containerPolicy.clear(object9);
        }
        object5 = object8;
        synchronized (object5) {
            Object object10;
            object4 = containerPolicy.iteratorFor(object8);
            while (containerPolicy.hasNext(object4)) {
                object3 = containerPolicy.nextEntry(object4, mergeManager.getSession());
                object10 = containerPolicy.unwrapIteratorResult(object3);
                if (object10 == null) continue;
                if (this.shouldMergeCascadeParts(mergeManager)) {
                    if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                        mergeManager.mergeChanges(mergeManager.getObjectToMerge(object10), (ObjectChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object10));
                    } else {
                        mergeManager.mergeChanges(mergeManager.getObjectToMerge(object10), null);
                    }
                }
                object3 = containerPolicy.createWrappedObjectFromExistingWrappedObject(object3, object2, this.referenceDescriptor, mergeManager);
                Object object11 = object9;
                synchronized (object11) {
                    if (bl2) {
                        ((ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(object, this.getAttributeName(), object9, object3, CollectionChangeEvent.ADD));
                    }
                    containerPolicy.addInto(object3, object9, mergeManager.getSession());
                }
            }
            if (bl2 && this.descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (object3 = ((AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (object10 = (CollectionChangeRecord)((ObjectChangeSet)object3).getChangesForAttributeNamed(this.getAttributeName())) != null) {
                if (!((DeferrableChangeRecord)object10).isDeferred()) {
                    if (!((CollectionChangeRecord)object10).hasChanges()) {
                        ((ObjectChangeSet)object3).removeChange(this.getAttributeName());
                    }
                } else {
                    ((DeferrableChangeRecord)object10).setLatestCollection(object9);
                }
            }
        }
        this.setRealAttributeValueInObject(object, object9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeChangesForCollectionMembers(Object object, Object object2, Object object3, MergeManager mergeManager, boolean bl) {
        Object object4 = this.containerPolicy.iteratorFor(object);
        while (this.containerPolicy.hasNext(object4)) {
            Object object5 = this.containerPolicy.nextEntry(object4, mergeManager.getSession());
            Object object6 = this.containerPolicy.unwrapIteratorResult(object5);
            if (object6 == null) continue;
            if (this.shouldMergeCascadeParts(mergeManager)) {
                if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                    mergeManager.mergeChanges(mergeManager.getObjectToMerge(object6), (ObjectChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object6));
                } else {
                    mergeManager.mergeChanges(mergeManager.getObjectToMerge(object6), null);
                }
            }
            object6 = this.referenceDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(object6), mergeManager.getSession());
            Object object7 = object2;
            synchronized (object7) {
                if (bl) {
                    ((ObjectChangeListener)((ChangeTracker)object3)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(object3, this.getAttributeName(), object2, object6, CollectionChangeEvent.ADD));
                }
                this.containerPolicy.addInto(object5, object2, mergeManager.getSession());
            }
        }
    }

    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, ObjectChangeSet objectChangeSet, Map map) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(objectLevelModifyQuery)) {
            return;
        }
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
            insertObjectQuery.setIsExecutionClone(true);
            insertObjectQuery.setObject(this.containerPolicy.unwrapIteratorResult(object));
            insertObjectQuery.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
            objectLevelModifyQuery.getSession().executeQuery(insertObjectQuery);
        } else {
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (objectChangeSet == null && objectLevelModifyQuery.getSession().isUnitOfWork() && ((UnitOfWorkImpl)objectLevelModifyQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)objectLevelModifyQuery.getSession()).getUnitOfWorkChangeSet();
                objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(objectLevelModifyQuery.getObject());
            }
            WriteObjectQuery writeObjectQuery = new WriteObjectQuery();
            writeObjectQuery.setIsExecutionClone(true);
            writeObjectQuery.setObject(this.containerPolicy.unwrapIteratorResult(object));
            writeObjectQuery.setObjectChangeSet(objectChangeSet);
            writeObjectQuery.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
            objectLevelModifyQuery.getSession().executeQuery(writeObjectQuery);
        }
    }

    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, Map map) throws DatabaseException, OptimisticLockException {
        if (this.isPrivateOwned() && !objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            this.containerPolicy.deleteWrappedObject(object, objectLevelModifyQuery.getSession());
        }
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(objectLevelModifyQuery)) {
            return;
        }
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        WriteObjectQuery writeObjectQuery = new WriteObjectQuery();
        writeObjectQuery.setIsExecutionClone(true);
        writeObjectQuery.setObject(object);
        writeObjectQuery.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
        objectLevelModifyQuery.getSession().executeQuery(writeObjectQuery);
    }

    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl unitOfWorkImpl) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        for (ObjectChangeSet objectChangeSet : collectionChangeRecord.getRemoveObjectList().values()) {
            this.containerPolicy.postCalculateChanges(objectChangeSet, this.referenceDescriptor, this, unitOfWorkImpl);
        }
    }

    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Iterator iterator = (Iterator)this.containerPolicy.iteratorFor(this.getRealAttributeValueFromObject(object, unitOfWorkImpl));
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.containerPolicy.recordPrivateOwnedRemovals(e, this.referenceDescriptor, unitOfWorkImpl);
            }
        }
    }

    protected void prepareTranslationRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object object = deleteObjectQuery.getObject();
            Object object2 = this.getAttributeValueFromObject(object);
            Object object3 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object3)) {
                Object object4 = this.containerPolicy.nextEntry(object3, deleteObjectQuery.getSession());
                this.containerPolicy.propogatePostDelete(deleteObjectQuery, object4);
            }
        }
    }

    public void postInitialize(AbstractSession abstractSession) {
        this.getContainerPolicy().postInitialize(abstractSession);
    }

    public void postInsert(UpdateObjectQuery updateObjectQuery) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object object = updateObjectQuery.getObject();
            Object object2 = this.getAttributeValueFromObject(object);
            Object object3 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object3)) {
                Object object4 = this.containerPolicy.nextEntry(object3, updateObjectQuery.getSession());
                this.containerPolicy.propogatePostInsert(updateObjectQuery, updateObjectQuery.getObject());
            }
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object object = writeObjectQuery.getObject();
            Object object2 = this.getAttributeValueFromObject(object);
            Object object3 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object3)) {
                Object object4 = this.containerPolicy.nextEntry(object3, writeObjectQuery.getSession());
                this.containerPolicy.propogatePreInsert(writeObjectQuery, object4);
            }
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object object = writeObjectQuery.getObject();
            Object object2 = this.getAttributeValueFromObject(object);
            Object object3 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object3)) {
                Object object4 = this.containerPolicy.nextEntry(object3, writeObjectQuery.getSession());
                this.containerPolicy.propogatePreUpdate(writeObjectQuery, object4);
            }
        }
    }

    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, Hashtable hashtable, CacheKey cacheKey) throws DatabaseException, OptimisticLockException {
        this.objectUnchangedDuringUpdate(objectLevelModifyQuery, object);
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            return this.getRealCollectionAttributeValueFromObject(objectLevelModifyQuery.getBackupClone(), objectLevelModifyQuery.getSession());
        }
        this.prepareTranslationRow(objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
        return objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)this.getSelectionQuery(), objectLevelModifyQuery.getTranslationRow());
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return remoteSessionController.replaceValueHoldersInAll(object, this.getContainerPolicy());
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        ((ReadAllQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setCustomDeleteAllQuery(ModifyQuery modifyQuery) {
        this.setDeleteAllQuery(modifyQuery);
        this.setHasCustomDeleteAllQuery(true);
    }

    protected void setDeleteAllQuery(ModifyQuery modifyQuery) {
        this.deleteAllQuery = modifyQuery;
    }

    public void setDeleteAllSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomDeleteAllQuery(dataModifyQuery);
    }

    public void setDeleteAllCall(Call call) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setCall(call);
        this.setCustomDeleteAllQuery(dataModifyQuery);
    }

    protected void setHasCustomDeleteAllQuery(boolean bl) {
        this.hasCustomDeleteAllQuery = bl;
    }

    protected void setSelectionQueryContainerPolicy(ContainerPolicy containerPolicy) {
        ((ReadAllQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setSessionName(String string) {
        this.getDeleteAllQuery().setSessionName(string);
        this.getSelectionQuery().setSessionName(string);
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        this.getContainerPolicy().recordAddToCollectionInChangeRecord((ObjectChangeSet)object2, collectionChangeRecord);
        if (object != null) {
            ((ObjectChangeSet)object2).setNewKey(object);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        this.getContainerPolicy().recordRemoveFromCollectionInChangeRecord((ObjectChangeSet)object2, collectionChangeRecord);
        if (object != null) {
            ((ObjectChangeSet)object2).setOldKey(object);
        }
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.setOriginalCollection(object3);
        }
        collectionChangeRecord.setLatestCollection(object2);
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    public void updateCollectionChangeRecord(CollectionChangeEvent collectionChangeEvent, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        if (collectionChangeEvent != null && collectionChangeEvent.getNewValue() != null) {
            Object object = collectionChangeEvent.getNewValue();
            ClassDescriptor classDescriptor = !this.getReferenceDescriptor().hasInheritance() ? this.getReferenceDescriptor() : unitOfWorkImpl.getDescriptor(object);
            object = classDescriptor.getObjectBuilder().unwrapObject(object, unitOfWorkImpl);
            ObjectChangeSet objectChangeSet2 = classDescriptor.getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), unitOfWorkImpl);
            CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
            if (collectionChangeRecord == null) {
                collectionChangeRecord = new CollectionChangeRecord(objectChangeSet);
                collectionChangeRecord.setAttribute(this.getAttributeName());
                collectionChangeRecord.setMapping(this);
                objectChangeSet.addChange(collectionChangeRecord);
            }
            this.getContainerPolicy().recordUpdateToCollectionInChangeRecord(collectionChangeEvent, objectChangeSet2, collectionChangeRecord);
        }
    }

    public void setChangeListener(Object object, PropertyChangeListener propertyChangeListener, UnitOfWorkImpl unitOfWorkImpl) {
        if (this.getIndirectionPolicy().usesTransparentIndirection() && this.isAttributeValueInstantiated(object)) {
            Object object2 = this.getRealAttributeValueFromObject(object, unitOfWorkImpl);
            if (!(object2 instanceof CollectionChangeTracker)) {
                Object object3 = object2;
                ContainerPolicy containerPolicy = this.getContainerPolicy();
                if (object2 == null) {
                    object3 = containerPolicy.containerInstance(1);
                } else {
                    object3 = containerPolicy.containerInstance(containerPolicy.sizeFor(object2));
                    Object object4 = containerPolicy.iteratorFor(object2);
                    while (containerPolicy.hasNext(object4)) {
                        containerPolicy.addInto(containerPolicy.next(object4, unitOfWorkImpl), object3, unitOfWorkImpl);
                    }
                }
                this.setRealAttributeValueInObject(object, object3);
                ((CollectionChangeTracker)object3).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)object3)._persistence_setPropertyChangeListener(propertyChangeListener);
            } else {
                ((CollectionChangeTracker)object2).setTrackedAttributeName(this.getAttributeName());
                ((CollectionChangeTracker)object2)._persistence_setPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    public void useCollectionClass(Class clazz) {
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz, this.hasOrderBy());
        this.setContainerPolicy(containerPolicy);
    }

    public void useSortedSetClass(Class clazz, Comparator comparator) {
        try {
            SortedCollectionContainerPolicy sortedCollectionContainerPolicy = (SortedCollectionContainerPolicy)ContainerPolicy.buildPolicyFor(clazz);
            sortedCollectionContainerPolicy.setComparator(comparator);
            this.setContainerPolicy(sortedCollectionContainerPolicy);
        }
        catch (ClassCastException classCastException) {
            this.useCollectionClass(clazz);
        }
    }

    public void useSortedSetClassName(String string) {
        this.useSortedSetClassName(string, null);
    }

    public void useSortedSetClassName(String string, String string2) {
        SortedCollectionContainerPolicy sortedCollectionContainerPolicy = new SortedCollectionContainerPolicy(string);
        sortedCollectionContainerPolicy.setComparatorClassName(string2);
        this.setContainerPolicy(sortedCollectionContainerPolicy);
    }

    public void useCollectionClassName(String string) {
        this.setContainerPolicy(new CollectionContainerPolicy(string));
    }

    public void useListClassName(String string) {
        this.setContainerPolicy(new ListContainerPolicy(string));
    }

    public void useMapClass(Class clazz, String string) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        containerPolicy.setKeyName(string, this.getReferenceClassName());
        this.setContainerPolicy(containerPolicy);
    }

    public void useMapClass(Class clazz) {
        this.useMapClass(clazz, null);
    }

    public void useMapClassName(String string, String string2) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy mapContainerPolicy = new MapContainerPolicy(string);
        mapContainerPolicy.setKeyName(string2, this.getReferenceClass().getName());
        this.setContainerPolicy(mapContainerPolicy);
    }

    public void useTransparentCollection() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
    }

    public void useTransparentSet() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(IndirectSet.class);
        this.setSelectionQueryContainerPolicy(ContainerPolicy.buildPolicyFor(HashSet.class));
    }

    public void useTransparentList() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useCollectionClass(ClassConstants.IndirectList_Class);
        this.setSelectionQueryContainerPolicy(ContainerPolicy.buildPolicyFor(Vector.class));
    }

    public void useTransparentMap(String string) {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class, string);
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(Hashtable.class);
        containerPolicy.setKeyName(string, this.getReferenceClass());
        this.setSelectionQueryContainerPolicy(containerPolicy);
    }

    public void validateBeforeInitialization(AbstractSession abstractSession) throws DescriptorException {
        super.validateBeforeInitialization(abstractSession);
        this.getIndirectionPolicy().validateContainerPolicy(abstractSession.getIntegrityChecker());
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class clazz = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeTypeForCollection(clazz, abstractSession.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class clazz = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnTypeForCollection(clazz, abstractSession.getIntegrityChecker());
            Class clazz2 = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterTypeForCollection(clazz2, abstractSession.getIntegrityChecker());
        }
    }

    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        Object object2;
        Object object3;
        if (this.isReadOnly()) {
            return true;
        }
        if (this.isPrivateOwned()) {
            object3 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
            object2 = this.getContainerPolicy();
            Object object4 = ((ContainerPolicy)object2).iteratorFor(object3);
            while (((ContainerPolicy)object2).hasNext(object4)) {
                if (abstractSession.verifyDelete(((ContainerPolicy)object2).next(object4, abstractSession))) continue;
                return false;
            }
        }
        object3 = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, abstractSession);
        this.prepareTranslationRow((AbstractRecord)object3, object, abstractSession);
        object2 = abstractSession.executeQuery((DatabaseQuery)this.getSelectionQuery(), (AbstractRecord)object3);
        return this.getContainerPolicy().isEmpty(object2);
    }

    public void addToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        if (object2 != null) {
            ClassDescriptor classDescriptor = !this.getReferenceDescriptor().hasInheritance() ? this.getReferenceDescriptor() : unitOfWorkImpl.getDescriptor(object2);
            object2 = classDescriptor.getObjectBuilder().unwrapObject(object2, unitOfWorkImpl);
            ObjectChangeSet objectChangeSet2 = classDescriptor.getObjectBuilder().createObjectChangeSet(object2, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), unitOfWorkImpl);
            this.simpleAddToCollectionChangeRecord(object, objectChangeSet2, objectChangeSet, unitOfWorkImpl);
        }
    }

    public boolean isChangeTrackingSupported(Project project) {
        return this.getIndirectionPolicy().usesTransparentIndirection();
    }

    public void removeFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        if (object2 != null) {
            ClassDescriptor classDescriptor = !this.getReferenceDescriptor().hasInheritance() ? this.getReferenceDescriptor() : unitOfWorkImpl.getDescriptor(object2);
            object2 = classDescriptor.getObjectBuilder().unwrapObject(object2, unitOfWorkImpl);
            ObjectChangeSet objectChangeSet2 = classDescriptor.getObjectBuilder().createObjectChangeSet(object2, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), unitOfWorkImpl);
            this.simpleRemoveFromCollectionChangeRecord(object, objectChangeSet2, objectChangeSet, unitOfWorkImpl);
        }
    }

    public org.eclipse.persistence.internal.sessions.ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object2;
        Object object3 = null;
        object3 = this.getAttributeValueFromObject(object);
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object4 = null;
        object4 = object3 != null ? this.getRealCollectionAttributeValueFromObject(object, abstractSession) : containerPolicy.containerInstance(1);
        Object object5 = containerPolicy.iteratorFor(object4);
        while (containerPolicy.hasNext(object5)) {
            object2 = containerPolicy.next(object5, abstractSession);
            if (object2 == null) continue;
            identityHashMap.put(object2, object2);
        }
        object2 = new CollectionChangeRecord(objectChangeSet);
        ((org.eclipse.persistence.internal.sessions.ChangeRecord)object2).setAttribute(this.getAttributeName());
        ((org.eclipse.persistence.internal.sessions.ChangeRecord)object2).setMapping(this);
        ((CollectionChangeRecord)object2).addAdditionChange(identityHashMap, containerPolicy, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), abstractSession);
        if (((CollectionChangeRecord)object2).hasChanges()) {
            return object2;
        }
        return null;
    }

    public Object valueFromPKList(Object[] objectArray, AbstractSession abstractSession) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = containerPolicy.containerInstance();
        for (int i = 0; i < objectArray.length; ++i) {
            Vector vector = null;
            vector = this.getReferenceDescriptor().hasCMPPolicy() ? this.getReferenceDescriptor().getCMPPolicy().createPkVectorFromKey(objectArray[i], abstractSession) : (Vector)objectArray[i];
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setReferenceClass(this.getReferenceClass());
            readObjectQuery.setSelectionKey(vector);
            readObjectQuery.setIsExecutionClone(true);
            containerPolicy.addInto(abstractSession.executeQuery(readObjectQuery), object, abstractSession);
        }
        return object;
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Object object = this.getContainerPolicy().containerInstance();
        Vector vector = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord, abstractSession);
        CacheKey cacheKey = new CacheKey(vector);
        List list = joinedAttributeManager.getDataResultsByPrimaryKey().get(cacheKey);
        ObjectLevelReadQuery objectLevelReadQuery = this.prepareNestedJoinQueryClone(abstractRecord, list, joinedAttributeManager, objectBuildingQuery, abstractSession);
        HashSet<CacheKey> hashSet = new HashSet<CacheKey>();
        for (int i = 0; i < list.size(); ++i) {
            AbstractRecord abstractRecord2;
            AbstractRecord abstractRecord3 = abstractRecord2 = (AbstractRecord)list.get(i);
            abstractRecord3 = this.trimRowForJoin(abstractRecord3, joinedAttributeManager, abstractSession);
            Vector vector2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord3, abstractSession);
            if (vector2 == null) {
                return this.getIndirectionPolicy().valueFromRow(object);
            }
            CacheKey cacheKey2 = new CacheKey(vector2);
            if (hashSet.contains(cacheKey2)) continue;
            objectLevelReadQuery.setTranslationRow(abstractRecord3);
            hashSet.add(cacheKey2);
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().buildObject(objectLevelReadQuery, abstractRecord3);
            Object object3 = this.getContainerPolicy().buildKeyFromJoinedRow(abstractRecord3, joinedAttributeManager, objectLevelReadQuery, abstractSession);
            objectLevelReadQuery.setTranslationRow(null);
            if (object3 == null) {
                this.getContainerPolicy().addInto(object2, object, abstractSession);
                continue;
            }
            this.getContainerPolicy().addInto(object3, object2, object, abstractSession);
        }
        return this.getIndirectionPolicy().valueFromRow(object);
    }
}

